/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Tag;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.RemoteRuleMatch;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResultExtender {
    private static final Logger logger = LoggerFactory.getLogger(ResultExtender.class);
    private final URL url;
    private final int connectTimeoutMillis;
    private final ObjectMapper mapper = new ObjectMapper();

    ResultExtender(String url, int connectTimeoutMillis) {
        this.url = Tools.getUrl((String)url);
        if (connectTimeoutMillis <= 0) {
            throw new IllegalArgumentException("connectTimeoutMillis must be > 0: " + connectTimeoutMillis);
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @NotNull
    List<RuleMatch> getFilteredExtensionMatches(List<RuleMatch> matches, List<RemoteRuleMatch> extensionMatches) {
        ArrayList<RuleMatch> filteredExtMatches = new ArrayList<RuleMatch>();
        for (RemoteRuleMatch extensionMatch : extensionMatches) {
            if (extensionMatch.isTouchedByOneOf(matches)) continue;
            AnalyzedSentence sentence = new AnalyzedSentence(new AnalyzedTokenReadings[0]);
            String catId = extensionMatch.getCategoryId().orElse(Categories.MISC.getId().toString());
            HiddenRule hiddenRule = new HiddenRule(catId, extensionMatch.getCategory().orElse("(unknown)"), extensionMatch.getLocQualityIssueType().orElse(null), extensionMatch.getTags(), extensionMatch.estimatedContextForSureMatch());
            RuleMatch hiddenRuleMatch = new RuleMatch((Rule)hiddenRule, sentence, extensionMatch.getErrorOffset(), extensionMatch.getErrorOffset() + extensionMatch.getErrorLength(), "(hidden message)");
            filteredExtMatches.add(hiddenRuleMatch);
        }
        return filteredExtMatches;
    }

    @NotNull
    static List<RuleMatch> getAsHiddenMatches(List<RuleMatch> matches, List<RuleMatch> extensionMatches) {
        ArrayList<RuleMatch> filteredExtMatches = new ArrayList<RuleMatch>();
        for (RuleMatch extensionMatch : extensionMatches) {
            Rule rule = extensionMatch.getRule();
            Predicate<RuleMatch> touchedByMatch = m -> extensionMatch.getFromPos() <= m.getToPos() && extensionMatch.getToPos() >= m.getFromPos();
            if (!matches.stream().noneMatch(touchedByMatch)) continue;
            AnalyzedSentence sentence = extensionMatch.getSentence();
            String issueType = null;
            if (rule.getLocQualityIssueType() != null) {
                issueType = rule.getLocQualityIssueType().toString();
            }
            String categoryId = rule.getCategory().getId().toString();
            String categoryName = rule.getCategory().getName();
            HiddenRule hiddenRule = new HiddenRule(categoryId, categoryName, issueType, rule.getTags(), rule.estimateContextForSureMatch());
            RuleMatch hiddenRuleMatch = new RuleMatch((Rule)hiddenRule, sentence, extensionMatch.getFromPos(), extensionMatch.getToPos(), "(hidden message)");
            filteredExtMatches.add(hiddenRuleMatch);
        }
        return filteredExtMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<RemoteRuleMatch> getExtensionMatches(String plainText, Map<String, String> params) throws IOException {
        HttpURLConnection huc = (HttpURLConnection)this.url.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        huc.setConnectTimeout(this.connectTimeoutMillis);
        huc.setReadTimeout(this.connectTimeoutMillis * 2);
        float factor = (float)plainText.length() / 1000.0f;
        if (factor > 1.0f) {
            int increasedTimeout = (int)((float)(this.connectTimeoutMillis * 2) * Math.min(factor, 5.0f));
            huc.setReadTimeout(increasedTimeout);
        }
        huc.setRequestMethod("POST");
        huc.setDoOutput(true);
        try {
            huc.connect();
            DataOutputStream wr = new DataOutputStream(huc.getOutputStream());
            Object object = null;
            try {
                String urlParameters = "";
                List<String> ignoredParameters = Arrays.asList("enableHiddenRules", "username", "password", "token", "apiKey", "c");
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (ignoredParameters.contains(entry.getKey())) continue;
                    urlParameters = urlParameters + "&" + this.encode(entry.getKey()) + "=" + this.encode(entry.getValue());
                }
                wr.write(urlParameters.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (wr != null) {
                    if (object != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        wr.close();
                    }
                }
            }
            InputStream input = huc.getInputStream();
            object = this.parseJson(input);
            return object;
        }
        catch (SocketTimeoutException | SSLHandshakeException e) {
            logger.error("Error while querying hidden matches server", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.warn("Warn: Failed to query hidden matches server at " + this.url + ": " + e.getClass() + ": " + e.getMessage() + ", input was " + plainText.length() + " characters - request-specific error, ignoring");
            List<RemoteRuleMatch> list = Collections.emptyList();
            return list;
        }
        finally {
            huc.disconnect();
        }
    }

    private String encode(String plainText) throws UnsupportedEncodingException {
        return URLEncoder.encode(plainText, StandardCharsets.UTF_8.name());
    }

    @NotNull
    private List<RemoteRuleMatch> parseJson(InputStream inputStream) throws IOException {
        Map map = (Map)this.mapper.readValue(inputStream, Map.class);
        ArrayList matches = (ArrayList)map.get("matches");
        ArrayList<RemoteRuleMatch> result = new ArrayList<RemoteRuleMatch>();
        for (Object match : matches) {
            RemoteRuleMatch remoteMatch = this.getMatch((Map)match);
            result.add(remoteMatch);
        }
        return result;
    }

    @NotNull
    private RemoteRuleMatch getMatch(Map<String, Object> match) {
        List<String> urls;
        Map rule = (Map)match.get("rule");
        int offset = (Integer)this.getRequired(match, "offset");
        int errorLength = (Integer)this.getRequired(match, "length");
        Map context = (Map)match.get("context");
        int contextOffset = (Integer)this.getRequired(context, "offset");
        int contextForSureMatch = match.get("contextForSureMatch") != null ? (Integer)match.get("contextForSureMatch") : 0;
        RemoteRuleMatch remoteMatch = new RemoteRuleMatch(this.getRequiredString(rule, "id"), this.getRequiredString(match, "message"), this.getRequiredString(context, "text"), contextOffset, offset, errorLength, contextForSureMatch);
        remoteMatch.setShortMsg(this.getOrNull(match, "shortMessage"));
        remoteMatch.setRuleSubId(this.getOrNull(rule, "subId"));
        remoteMatch.setLocQualityIssueType(this.getOrNull(rule, "issueType"));
        List<String> tags = this.getTagList(rule, "tags");
        if (tags.size() > 0) {
            ArrayList<Tag> tagsObjects = new ArrayList<Tag>();
            for (String tag : tags) {
                tagsObjects.add(Tag.valueOf((String)tag));
            }
            remoteMatch.setTags(tagsObjects);
        }
        if ((urls = this.getValueList(rule, "urls")).size() > 0) {
            remoteMatch.setUrl(urls.get(0));
        }
        Map category = (Map)rule.get("category");
        remoteMatch.setCategory(this.getOrNull(category, "name"));
        remoteMatch.setCategoryId(this.getOrNull(category, "id"));
        remoteMatch.setReplacements(this.getValueList(match, "replacements"));
        return remoteMatch;
    }

    private Object getRequired(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return val;
        }
        throw new RuntimeException("JSON item " + elem + " doesn't contain required property '" + propertyName + "'");
    }

    private String getRequiredString(Map<String, Object> elem, String propertyName) {
        return (String)this.getRequired(elem, propertyName);
    }

    private String getOrNull(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return (String)val;
        }
        return null;
    }

    private List<String> getValueList(Map<String, Object> match, String propertyName) {
        List matches = (List)match.get(propertyName);
        ArrayList<String> l = new ArrayList<String>();
        if (matches != null) {
            for (Object o : matches) {
                Map item = (Map)o;
                l.add((String)item.get("value"));
            }
        }
        return l;
    }

    private List<String> getTagList(Map<String, Object> match, String propertyName) {
        List matches = (List)match.get(propertyName);
        ArrayList<String> l = new ArrayList<String>();
        if (matches != null) {
            for (Object o : matches) {
                l.add((String)o);
            }
        }
        return l;
    }

    static class HiddenRule
    extends Rule {
        final String categoryId;
        final String categoryName;
        final ITSIssueType itsType;
        final int estimatedContextForSureMatch;
        final List<Tag> tags;

        HiddenRule(String categoryId, String categoryName, String type, List<Tag> tags, int estimatedContextForSureMatch) {
            this.categoryId = categoryId;
            this.categoryName = categoryName;
            this.itsType = type != null ? ITSIssueType.getIssueType((String)type) : ITSIssueType.Uncategorized;
            this.estimatedContextForSureMatch = estimatedContextForSureMatch;
            this.tags = tags;
        }

        @NotNull
        public final Category getCategory() {
            return new Category(new CategoryId(this.categoryId), this.categoryName);
        }

        public String getId() {
            return "HIDDEN_RULE";
        }

        public ITSIssueType getLocQualityIssueType() {
            return this.itsType;
        }

        public String getDescription() {
            return "(description hidden)";
        }

        public RuleMatch[] match(AnalyzedSentence sentence) {
            throw new RuntimeException("not implemented");
        }

        public int estimateContextForSureMatch() {
            return this.estimatedContextForSureMatch;
        }

        @NotNull
        public List<Tag> getTags() {
            return this.tags == null ? Collections.emptyList() : this.tags;
        }
    }
}

