/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.DictionaryMatchFilter;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.Pipeline;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinePool {
    private static final Logger logger = LoggerFactory.getLogger(PipelinePool.class);
    static final long PIPELINE_EXPIRE_TIME = 900000L;
    private final HTTPServerConfig config;
    private final ResultCache cache;
    private final LoadingCache<PipelineSettings, ConcurrentLinkedQueue<Pipeline>> pool;
    private final boolean internalServer;
    private long pipelineExpireCheckTimestamp;
    private long pipelinesUsed;
    private long requests;

    PipelinePool(HTTPServerConfig config, ResultCache cache, boolean internalServer) {
        this.internalServer = internalServer;
        this.config = config;
        this.cache = cache;
        this.pipelineExpireCheckTimestamp = System.currentTimeMillis();
        int maxPoolSize = config.getMaxPipelinePoolSize();
        int expireTime = config.getPipelineExpireTime();
        this.pool = config.isPipelineCachingEnabled() ? CacheBuilder.newBuilder().maximumSize((long)maxPoolSize).expireAfterAccess((long)expireTime, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<PipelineSettings, ConcurrentLinkedQueue<Pipeline>>(){

            public ConcurrentLinkedQueue<Pipeline> load(PipelineSettings key) {
                return new ConcurrentLinkedQueue<Pipeline>();
            }
        }) : null;
    }

    Pipeline getPipeline(PipelineSettings settings) throws Exception {
        if (this.pool != null) {
            Pipeline pipeline;
            long expireCheckDelta = System.currentTimeMillis() - this.pipelineExpireCheckTimestamp;
            if (expireCheckDelta > 900000L) {
                AtomicInteger removed = new AtomicInteger();
                this.pipelineExpireCheckTimestamp = System.currentTimeMillis();
                this.pool.asMap().forEach((s, queue) -> queue.removeIf(pipeline -> {
                    if (pipeline.isExpired()) {
                        removed.getAndIncrement();
                        return true;
                    }
                    return false;
                }));
                ServerTools.print("Removing " + removed.get() + " expired pipelines");
            }
            ++this.requests;
            ConcurrentLinkedQueue pipelines = (ConcurrentLinkedQueue)this.pool.get((Object)settings);
            if (this.requests % 1000L == 0L) {
                logger.info(String.format("Pipeline cache stats: %f hit rate", (double)this.pipelinesUsed / (double)this.requests));
            }
            if ((pipeline = (Pipeline)((Object)pipelines.poll())) == null) {
                pipeline = this.createPipeline(settings.lang, settings.motherTongue, settings.query, settings.globalConfig, settings.userConfig, this.config.getDisabledRuleIds());
            } else {
                ++this.pipelinesUsed;
            }
            return pipeline;
        }
        return this.createPipeline(settings.lang, settings.motherTongue, settings.query, settings.globalConfig, settings.userConfig, this.config.getDisabledRuleIds());
    }

    void returnPipeline(PipelineSettings settings, Pipeline pipeline) throws ExecutionException {
        if (this.pool == null) {
            return;
        }
        ConcurrentLinkedQueue pipelines = (ConcurrentLinkedQueue)this.pool.get((Object)settings);
        pipeline.refreshExpireTimer();
        pipelines.add(pipeline);
    }

    Pipeline createPipeline(Language lang, Language motherTongue, TextChecker.QueryParams params, GlobalConfig globalConfig, UserConfig userConfig, List<String> disabledRuleIds) throws Exception {
        Pipeline lt = new Pipeline(lang, params.altLanguages, motherTongue, this.cache, globalConfig, userConfig, params.inputLogging);
        lt.setMaxErrorsPerWordRate(this.config.getMaxErrorsPerWordRate());
        lt.disableRules(disabledRuleIds);
        if (this.config.getLanguageModelDir() != null) {
            lt.activateLanguageModelRules(this.config.getLanguageModelDir());
        }
        if (this.config.getWord2VecModelDir() != null) {
            lt.activateWord2VecModelRules(this.config.getWord2VecModelDir());
        }
        if (this.config.getRulesConfigFile() != null) {
            this.configureFromRulesFile(lt, lang);
        } else {
            this.configureFromGUI(lt, lang);
        }
        if (params.regressionTestMode) {
            List<RemoteRuleConfig> rules = Collections.emptyList();
            try {
                if (this.config.getRemoteRulesConfigFile() != null) {
                    rules = RemoteRuleConfig.load((File)this.config.getRemoteRulesConfigFile());
                }
            }
            catch (Exception e) {
                logger.error("Could not load remote rule configuration", (Throwable)e);
            }
            long timeout = Math.max(this.config.getMaxCheckTimeMillis() - 1L, 0L);
            rules = rules.stream().map(c -> new RemoteRuleConfig(c.getRuleId(), c.getUrl(), Integer.valueOf(c.getPort()), Integer.valueOf(0), Long.valueOf(timeout), Float.valueOf(0.0f), Integer.valueOf(0), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), c.getOptions())).collect(Collectors.toList());
            lt.activateRemoteRules(rules);
        } else {
            lt.activateRemoteRules(this.config.getRemoteRulesConfigFile());
        }
        if (params.useQuerySettings) {
            Tools.selectRules((JLanguageTool)lt, new HashSet<CategoryId>(params.disabledCategories), new HashSet<CategoryId>(params.enabledCategories), new HashSet<String>(params.disabledRules), new HashSet<String>(params.enabledRules), (boolean)params.useEnabledOnly, (boolean)params.enableTempOffRules);
        }
        if (userConfig.filterDictionaryMatches()) {
            lt.addMatchFilter((RuleMatchFilter)new DictionaryMatchFilter(userConfig));
        }
        if (this.pool != null) {
            lt.setupFinished();
        }
        return lt;
    }

    private void configureFromRulesFile(JLanguageTool lt, Language lang) throws IOException {
        ServerTools.print("Using options configured in " + this.config.getRulesConfigFile());
        if (this.config.getRulesConfigFile() == null) {
            throw new RuntimeException("config.getRulesConfigFile() is null");
        }
        org.languagetool.gui.Tools.configureFromRules((JLanguageTool)lt, (Configuration)new Configuration(this.config.getRulesConfigFile().getCanonicalFile().getParentFile(), this.config.getRulesConfigFile().getName(), lang));
    }

    private void configureFromGUI(JLanguageTool lt, Language lang) throws IOException {
        Configuration config = new Configuration(lang);
        if (this.internalServer && config.getUseGUIConfig()) {
            ServerTools.print("Using options configured in the GUI");
            org.languagetool.gui.Tools.configureFromRules((JLanguageTool)lt, (Configuration)config);
        }
    }

    public static class PipelineSettings {
        private final Language lang;
        private final Language motherTongue;
        private final TextChecker.QueryParams query;
        private final UserConfig userConfig;
        private final GlobalConfig globalConfig;

        PipelineSettings(Language lang, Language motherTongue, TextChecker.QueryParams params, GlobalConfig globalConfig, UserConfig userConfig) {
            this.lang = lang;
            this.motherTongue = motherTongue;
            this.query = params;
            this.userConfig = userConfig;
            this.globalConfig = globalConfig;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.lang).append((Object)this.motherTongue).append((Object)this.query).append((Object)this.globalConfig).append((Object)this.userConfig).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PipelineSettings other = (PipelineSettings)obj;
            return new EqualsBuilder().append((Object)this.lang, (Object)other.lang).append((Object)this.motherTongue, (Object)other.motherTongue).append((Object)this.query, (Object)other.query).append((Object)this.globalConfig, (Object)other.globalConfig).append((Object)this.userConfig, (Object)other.userConfig).isEquals();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("lang", (Object)this.lang).append("motherTongue", (Object)this.motherTongue).append("query", (Object)this.query).append("globalConfig", (Object)this.globalConfig).append("user", (Object)this.userConfig).build();
        }
    }
}

