/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.AuthException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.tools.StringTools;

class UserLimits {
    private int maxTextLength;
    private long maxCheckTimeMillis;
    private Long premiumUid;
    private boolean skipLimits;
    private static final LoadingCache<Account, String> cache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Account, String>(){

        public String load(@NotNull Account account) throws IOException {
            return UserLimits.getTokenFromServer(account.username, account.password);
        }
    });

    static UserLimits getDefaultLimits(HTTPServerConfig config) {
        return new UserLimits(config.maxTextLength, config.maxCheckTimeMillis, null);
    }

    static UserLimits getLimitsFromToken(HTTPServerConfig config, String jwtToken) {
        DecodedJWT decodedToken;
        Objects.requireNonNull(jwtToken);
        String secretKey = config.getSecretTokenKey();
        if (secretKey == null) {
            throw new RuntimeException("You specified a 'token' parameter but this server is not configured to accept tokens");
        }
        Algorithm algorithm = Algorithm.HMAC256((String)secretKey);
        try {
            JWT.require((Algorithm)algorithm).build().verify(jwtToken);
            decodedToken = JWT.decode((String)jwtToken);
        }
        catch (JWTDecodeException e) {
            throw new AuthException("Could not decode token '" + jwtToken + "'", (Exception)((Object)e));
        }
        Claim maxTextLengthClaim = decodedToken.getClaim("maxTextLength");
        Claim premiumClaim = decodedToken.getClaim("premium");
        boolean hasPremium = !premiumClaim.isNull() && premiumClaim.asBoolean() != false;
        Claim uidClaim = decodedToken.getClaim("uid");
        long uid = uidClaim.isNull() ? -1L : uidClaim.asLong();
        UserLimits userLimits = new UserLimits(maxTextLengthClaim.isNull() ? config.maxTextLength : maxTextLengthClaim.asInt(), config.maxCheckTimeMillis, hasPremium ? Long.valueOf(uid) : null);
        userLimits.skipLimits = decodedToken.getClaim("skipLimits").isNull() ? false : decodedToken.getClaim("skipLimits").asBoolean();
        return userLimits;
    }

    public static UserLimits getLimitsByApiKey(HTTPServerConfig config, String username, String apiKey) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        Long id = db.getUserId(username, apiKey);
        return new UserLimits(config.maxTextLengthWithApiKey, config.maxCheckTimeWithApiKeyMillis, id);
    }

    static UserLimits getLimitsFromUserAccount(HTTPServerConfig config, String username, String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        String token = (String)cache.getUnchecked((Object)new Account(username, password));
        return UserLimits.getLimitsFromToken(config, token);
    }

    @NotNull
    private static String getTokenFromServer(String username, String password) {
        String url = "https://languagetoolplus.com/token";
        try {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("username", username);
            params.put("password", password);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes(StandardCharsets.UTF_8);
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            try {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.getOutputStream().write(postDataBytes);
                return StringTools.streamToString((InputStream)conn.getInputStream(), (String)"UTF-8");
            }
            catch (IOException e) {
                if (conn.getResponseCode() == 403) {
                    throw new AuthException("Could not get token for user '" + username + "' from " + url + ", invalid username or password (code: 403)", e);
                }
                throw new RuntimeException("Could not get token for user '" + username + "' from " + url, e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get token for user '" + username + "' from " + url, e);
        }
    }

    private UserLimits(int maxTextLength, long maxCheckTimeMillis, Long premiumUid) {
        this.maxTextLength = maxTextLength;
        this.maxCheckTimeMillis = maxCheckTimeMillis;
        this.premiumUid = premiumUid;
    }

    UserLimits(boolean skipLimits) {
        this.skipLimits = skipLimits;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    long getMaxCheckTimeMillis() {
        return this.maxCheckTimeMillis;
    }

    boolean getSkipLimits() {
        return this.skipLimits;
    }

    @Nullable
    Long getPremiumUid() {
        return this.premiumUid;
    }

    public String toString() {
        return "premiumUid=" + this.premiumUid + ", maxTextLength=" + this.maxTextLength + ", maxCheckTimeMillis=" + this.maxCheckTimeMillis;
    }

    static class Account {
        private final String username;
        private final String password;

        Account(String username, String password) {
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.username, account.username) && Objects.equals(this.password, account.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }
    }
}

