/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.UserDictEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseAccess {
    private static DatabaseAccess instance;
    private static SqlSessionFactory sqlSessionFactory;
    private static final Logger logger;
    private final Cache<Long, List<UserDictEntry>> userDictCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(24L, TimeUnit.HOURS).build();
    private final Cache<String, Long> dbLoggingCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(5000L).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DatabaseAccess(HTTPServerConfig config) {
        if (config.getDatabaseDriver() != null) {
            try {
                logger.info("Setting up database access, URL " + config.getDatabaseUrl() + ", driver: " + config.getDatabaseDriver() + ", user: " + config.getDatabaseUsername());
                InputStream inputStream = Resources.getResourceAsStream((String)"org/languagetool/server/mybatis-config.xml");
                Properties properties = new Properties();
                properties.setProperty("driver", config.getDatabaseDriver());
                properties.setProperty("url", config.getDatabaseUrl());
                properties.setProperty("username", config.getDatabaseUsername());
                properties.setProperty("password", config.getDatabasePassword());
                sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream, properties);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((PooledDataSource)sqlSessionFactory.getConfiguration().getEnvironment().getDataSource()).forceCloseAll()));
                DatabaseLogger.init(sqlSessionFactory);
                if (config.getDatabaseLogging()) return;
                logger.info("dbLogging not set to true, turning off logging");
                DatabaseLogger.getInstance().disableLogging();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            logger.info("Not setting up database access, dbDriver is not configured");
        }
    }

    static synchronized void init(HTTPServerConfig config) {
        if (instance == null) {
            instance = new DatabaseAccess(config);
        }
    }

    static synchronized DatabaseAccess getInstance() {
        if (instance == null) {
            throw new IllegalStateException("DatabaseAccess.init() has not been called yet");
        }
        return instance;
    }

    List<String> getUserDictWords(Long userId) {
        ArrayList<String> dictEntries;
        block19: {
            dictEntries = new ArrayList<String>();
            if (sqlSessionFactory == null) {
                return dictEntries;
            }
            try (SqlSession session = sqlSessionFactory.openSession();){
                try {
                    List dict = session.selectList("org.languagetool.server.UserDictMapper.selectWordList", (Object)userId);
                    for (UserDictEntry userDictEntry : dict) {
                        dictEntries.add(userDictEntry.getWord());
                    }
                    if (dict.size() <= 1000) {
                        this.userDictCache.put((Object)userId, (Object)dict);
                        break block19;
                    }
                    logger.info("WARN: Large dict size " + dict.size() + " for user " + userId + " - will not put user's dict in cache");
                }
                catch (Exception e) {
                    List cachedDictOrNull = (List)this.userDictCache.getIfPresent((Object)userId);
                    if (cachedDictOrNull != null) {
                        logger.error("ERROR: Could not get words from database for user " + userId + ": " + e.getMessage() + ", will use cached version (" + cachedDictOrNull.size() + " items). Full stack trace follows:" + ExceptionUtils.getStackTrace((Throwable)e));
                        for (UserDictEntry userDictEntry : cachedDictOrNull) {
                            dictEntries.add(userDictEntry.getWord());
                        }
                        break block19;
                    }
                    logger.error("ERROR: Could not get words from database for user " + userId + ": " + e.getMessage() + " - also, could not use version from cache, user id not found in cache, will use empty dict. Full stack trace follows:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return dictEntries;
    }

    List<UserDictEntry> getWords(Long userId, int offset, int limit) {
        if (sqlSessionFactory == null) {
            return new ArrayList<UserDictEntry>();
        }
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("userId", userId);
            List list = session.selectList("org.languagetool.server.UserDictMapper.selectWordList", map, new RowBounds(offset, limit));
            return list;
        }
    }

    boolean addWord(String word, Long userId) {
        this.validateWord(word);
        if (sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            List existingWords = session.selectList("org.languagetool.server.UserDictMapper.selectWord", map);
            if (existingWords.size() >= 1) {
                logger.info("Did not add '" + word + "' for user " + userId + " to list of ignored words, already exists");
                boolean bl = false;
                return bl;
            }
            Date now = new Date();
            map.put("created_at", now);
            map.put("updated_at", now);
            int affectedRows = session.insert("org.languagetool.server.UserDictMapper.addWord", map);
            logger.info("Added '" + word + "' for user " + userId + " to list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows == 1;
            return bl;
        }
    }

    Long getUserId(String username, String apiKey) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("username must be set");
        }
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("apiKey must be set");
        }
        if (sqlSessionFactory == null) {
            throw new IllegalStateException("sqlSessionFactory not initialized - has the database been configured?");
        }
        try {
            Long value = (Long)this.dbLoggingCache.get((Object)String.format("user_%s_%s", username, apiKey), () -> {
                try (SqlSession session = sqlSessionFactory.openSession();){
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("username", username);
                    map.put("apiKey", apiKey);
                    Long id = (Long)session.selectOne("org.languagetool.server.UserDictMapper.getUserIdByApiKey", map);
                    if (id == null) {
                        Long l = -1L;
                        return l;
                    }
                    Long l = id;
                    return l;
                }
            });
            if (value == -1L) {
                throw new IllegalArgumentException("No user found for given username '" + username + "' and given api key");
            }
            return value;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Could not fetch given user '" + username + "' from cache", e);
        }
    }

    boolean deleteWord(String word, Long userId) {
        if (sqlSessionFactory == null) {
            return false;
        }
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("word", word);
            map.put("userId", userId);
            int count = session.delete("org.languagetool.server.UserDictMapper.selectWord", map);
            if (count == 0) {
                logger.info("Did not delete '" + word + "' for user " + userId + " from list of ignored words, does not exist");
                boolean bl = false;
                return bl;
            }
            int affectedRows = session.delete("org.languagetool.server.UserDictMapper.deleteWord", map);
            logger.info("Deleted '" + word + "' for user " + userId + " from list of ignored words, affectedRows: " + affectedRows);
            boolean bl = affectedRows >= 1;
            return bl;
        }
    }

    Long getOrCreateServerId() {
        if (sqlSessionFactory == null) {
            return null;
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            Long id = (Long)this.dbLoggingCache.get((Object)("server_" + hostname), () -> {
                try (SqlSession session = sqlSessionFactory.openSession(true);){
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("hostname", hostname);
                    List result = session.selectList("org.languagetool.server.LogMapper.findServer", parameters);
                    if (result.size() > 0) {
                        Long l = (Long)result.get(0);
                        return l;
                    }
                    session.insert("org.languagetool.server.LogMapper.newServer", parameters);
                    Object value = parameters.get("id");
                    if (value == null) {
                        Long l = -1L;
                        return l;
                    }
                    Long l = (Long)value;
                    return l;
                }
                catch (PersistenceException e) {
                    logger.warn("Error: Could not fetch/register server id from database for server: " + hostname, (Throwable)e);
                    return -1L;
                }
            });
            if (id == -1L) {
                return null;
            }
            return id;
        }
        catch (UnknownHostException | ExecutionException e) {
            logger.warn("Error: Could not get hostname to fetch/register server id: ", (Throwable)e);
            return null;
        }
    }

    Long getOrCreateClientId(String client) {
        if (sqlSessionFactory == null || client == null) {
            return null;
        }
        try {
            Long id = (Long)this.dbLoggingCache.get((Object)("client_" + client), () -> {
                try (SqlSession session = sqlSessionFactory.openSession(true);){
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("name", client);
                    List result = session.selectList("org.languagetool.server.LogMapper.findClient", parameters);
                    if (result.size() > 0) {
                        Long l = (Long)result.get(0);
                        return l;
                    }
                    session.insert("org.languagetool.server.LogMapper.newClient", parameters);
                    Object value = parameters.get("id");
                    if (value == null) {
                        Long l = -1L;
                        return l;
                    }
                    Long l = (Long)value;
                    return l;
                }
                catch (PersistenceException e) {
                    logger.warn("Error: Could not get/register id for this client: " + client, (Throwable)e);
                    return -1L;
                }
            });
            if (id == -1L) {
                return null;
            }
            return id;
        }
        catch (ExecutionException e) {
            logger.warn("Failure in getOrCreateClientId with client '" + client + "': ", (Throwable)e);
            return null;
        }
    }

    private void validateWord(String word) {
        if (word == null || word.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid word, cannot be empty or whitespace only");
        }
        if (word.matches(".*\\s.*")) {
            throw new IllegalArgumentException("Invalid word, you can only words that don't contain spaces: '" + word + "'");
        }
    }

    public static void createAndFillTestTables() {
        DatabaseAccess.createAndFillTestTables(false);
    }

    public static void createAndFillTestTables(boolean mysql) {
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            String[] statements;
            System.out.println("Setting up tables and adding test user...");
            for (String statement : statements = new String[]{"org.languagetool.server.UserDictMapper.createUserTable", "org.languagetool.server.UserDictMapper.createIgnoreWordTable"}) {
                if (mysql) {
                    session.insert(statement + "MySQL");
                    continue;
                }
                session.insert(statement);
            }
            session.insert("org.languagetool.server.UserDictMapper.createTestUser1");
            session.insert("org.languagetool.server.UserDictMapper.createTestUser2");
        }
    }

    public static void deleteTestTables() {
        try (SqlSession session = sqlSessionFactory.openSession(true);){
            System.out.println("Deleting tables...");
            session.delete("org.languagetool.server.UserDictMapper.deleteUsersTable");
            session.delete("org.languagetool.server.UserDictMapper.deleteIgnoreWordsTable");
        }
    }

    /*
     * Exception decompiling
     */
    static ResultSet executeStatement(SQL sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        logger = LoggerFactory.getLogger(DatabaseAccess.class);
    }
}

