/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.xml.sax.SAXException;

class Pipeline
extends JLanguageTool {
    private boolean setup = false;
    private long lastUsedTimestamp = System.currentTimeMillis();

    void setupFinished() {
        this.setup = true;
    }

    void refreshExpireTimer() {
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    boolean isExpired() {
        long delta = System.currentTimeMillis() - this.lastUsedTimestamp;
        return delta > 900000L;
    }

    Pipeline(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig) {
        super(language, altLanguages, motherTongue, cache, globalConfig, userConfig);
    }

    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setCleanOverlappingMatches(cleanOverlappingMatches);
    }

    public void setMaxErrorsPerWordRate(float maxErrorsPerWordRate) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setMaxErrorsPerWordRate(maxErrorsPerWordRate);
    }

    public void setOutput(PrintStream printStream) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setOutput(printStream);
    }

    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        return super.loadPatternRules(filename);
    }

    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        return super.loadFalseFriendRules(filename);
    }

    public void activateLanguageModelRules(File indexDir) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.activateLanguageModelRules(indexDir);
    }

    public void activateWord2VecModelRules(File indexDir) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.activateWord2VecModelRules(indexDir);
    }

    public void addRule(Rule rule) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.addRule(rule);
    }

    public void disableRule(String ruleId) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableRule(ruleId);
    }

    public void disableRules(List<String> ruleIds) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableRules(ruleIds);
    }

    public void disableCategory(CategoryId id) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableCategory(id);
    }

    public Set<String> getDisabledRules() {
        return Collections.unmodifiableSet(super.getDisabledRules());
    }

    public void enableRule(String ruleId) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.enableRule(ruleId);
    }

    public void enableRuleCategory(CategoryId id) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.enableRuleCategory(id);
    }

    public List<String> getUnknownWords() {
        return Collections.unmodifiableList(super.getUnknownWords());
    }

    public Map<CategoryId, Category> getCategories() {
        return Collections.unmodifiableMap(super.getCategories());
    }

    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(super.getAllRules());
    }

    public List<Rule> getAllActiveRules() {
        return Collections.unmodifiableList(super.getAllActiveRules());
    }

    public List<Rule> getAllActiveOfficeRules() {
        return Collections.unmodifiableList(super.getAllActiveOfficeRules());
    }

    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String Id, String subId) {
        return Collections.unmodifiableList(super.getPatternRulesByIdAndSubId(Id, subId));
    }

    public void setConfigValues(Map<String, Integer> v) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setConfigValues(v);
    }

    static class IllegalPipelineMutationException
    extends RuntimeException {
        IllegalPipelineMutationException() {
            super("Pipeline is frozen; mutating shared JLanguageTool instance is forbidden.");
        }
    }
}

