/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;

class ApiV2 {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String ENCODING = "UTF-8";
    private final TextChecker textChecker;
    private final String allowOriginUrl;
    private final JsonFactory factory = new JsonFactory();

    ApiV2(TextChecker textChecker, String allowOriginUrl) {
        this.textChecker = textChecker;
        this.allowOriginUrl = allowOriginUrl;
    }

    void handleRequest(String path, HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        if (path.equals("languages")) {
            this.handleLanguagesRequest(httpExchange);
        } else if (path.equals("check")) {
            this.handleCheckRequest(httpExchange, parameters, errorRequestLimiter, remoteAddress);
        } else if (path.equals("log")) {
            this.handleLogRequest(httpExchange, parameters);
        } else {
            throw new RuntimeException("Unsupported action: '" + path + "'");
        }
    }

    private void handleLanguagesRequest(HttpExchange httpExchange) throws IOException {
        String response = this.getLanguages();
        ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private void handleCheckRequest(HttpExchange httpExchange, Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        AnnotatedText aText;
        if (parameters.containsKey("text")) {
            aText = new AnnotatedTextBuilder().addText(parameters.get("text")).build();
        } else if (parameters.containsKey("data")) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode data = mapper.readTree(parameters.get("data"));
            aText = this.getAnnotatedText(data, data.get("text").asText());
        } else {
            throw new RuntimeException("Missing 'text' or 'data' parameter");
        }
        this.textChecker.checkText(aText, httpExchange, parameters, errorRequestLimiter, remoteAddress);
    }

    private void handleLogRequest(HttpExchange httpExchange, Map<String, String> parameters) throws IOException {
        String message = parameters.get("message");
        if (message != null && message.length() > 250) {
            message = message.substring(0, 250) + "...";
        }
        ServerTools.print("Log message from client: " + message + " - User-Agent: " + httpExchange.getRequestHeaders().getFirst("User-Agent"));
        String response = "OK";
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private AnnotatedText getAnnotatedText(JsonNode data, String text) {
        AnnotatedTextBuilder textBuilder = new AnnotatedTextBuilder().addText(text);
        if (data.has("metaData")) {
            JsonNode metaData = data.get("metaData");
            Iterator it = metaData.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = metaData.get(key).asText();
                try {
                    AnnotatedText.MetaDataKey metaDataKey = AnnotatedText.MetaDataKey.valueOf((String)key);
                    textBuilder.addGlobalMetaData(metaDataKey, val);
                }
                catch (IllegalArgumentException e) {
                    textBuilder.addGlobalMetaData(key, val);
                }
            }
        }
        return textBuilder.build();
    }

    String getLanguages() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartArray();
            ArrayList languages = new ArrayList(Languages.get());
            languages.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
            for (Language lang : languages) {
                g.writeStartObject();
                g.writeStringField("name", lang.getName());
                g.writeStringField("code", lang.getShortCode());
                g.writeStringField("longCode", lang.getShortCodeWithCountryAndVariant());
                g.writeEndObject();
            }
            g.writeEndArray();
        }
        return sw.toString();
    }
}

