/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.List;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

@Experimental
public class AtDXmlSerializer {
    public String ruleMatchesToXml(List<RuleMatch> matches, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append("<results>\n");
        sb.append("<!-- Server: LanguageTool 3.5 (").append(JLanguageTool.BUILD_DATE).append(") -->\n");
        for (RuleMatch match : matches) {
            this.addRuleMatch(sb, match, text);
        }
        sb.append("</results>\n");
        return sb.toString();
    }

    private void addRuleMatch(StringBuilder sb, RuleMatch match, String text) {
        String errorText = text.substring(match.getFromPos(), match.getToPos());
        if (errorText.contains("(") || errorText.contains(")")) {
            return;
        }
        sb.append("  <error>\n");
        sb.append("    <string>").append(StringTools.escapeForXmlContent((String)errorText)).append("</string>\n");
        boolean hasShortMessage = match.getShortMessage() != null && match.getShortMessage().length() > 0;
        String cleanMessage = hasShortMessage ? match.getShortMessage() : match.getMessage().replace("<suggestion>", "'").replace("</suggestion>", "'");
        sb.append("    <description>").append(StringTools.escapeForXmlContent((String)cleanMessage)).append("</description>\n");
        String preContext = this.getPreContext(text, match.getFromPos());
        if (preContext.isEmpty()) {
            sb.append("    <precontext/>\n");
        } else {
            sb.append("    <precontext>").append(StringTools.escapeForXmlContent((String)preContext)).append("</precontext>\n");
        }
        if (match.getSuggestedReplacements().size() > 0) {
            sb.append("    <suggestions>\n");
            for (String suggestion : match.getSuggestedReplacements()) {
                sb.append("      <option>").append(StringTools.escapeForXmlContent((String)suggestion)).append("</option>\n");
            }
            sb.append("    </suggestions>\n");
        }
        String type = match.getRule().isDictionaryBasedSpellingRule() ? "spelling" : "grammar";
        sb.append("    <type>").append(StringTools.escapeForXmlContent((String)type)).append("</type>\n");
        sb.append("  </error>\n");
    }

    String getPreContext(String text, int fromPos) {
        String preText = text.substring(0, fromPos);
        String[] parts = preText.trim().split("\\s");
        if (parts.length == 0) {
            return "";
        }
        String lastPart = parts[parts.length - 1];
        if (lastPart.matches(".*[()\\[\\],;:/-].*")) {
            return "";
        }
        return lastPart;
    }
}

