/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.Configuration;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.AtDXmlSerializer;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.TextTooLongException;
import org.languagetool.tools.RuleMatchAsXmlSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

class LanguageToolHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_VALUE = "text/xml; charset=UTF-8";
    private static final String ENCODING = "utf-8";
    private static final int CONTEXT_SIZE = 40;
    private static int handleCount = 0;
    private final Set<String> allowedIps;
    private final boolean verbose;
    private final boolean internalServer;
    private final RequestLimiter requestLimiter;
    private final LinkedBlockingQueue<Runnable> workQueue;
    private final ExecutorService executorService;
    private final LanguageIdentifier identifier;
    private long maxCheckTimeMillis = -1L;
    private int maxTextLength = Integer.MAX_VALUE;
    private String allowOriginUrl;
    private boolean afterTheDeadlineMode;
    private Language afterTheDeadlineLanguage;
    private File languageModelDir;
    private int maxWorkQueueSize;
    private boolean trustXForwardForHeader = false;
    private Set<String> ownIps;
    private File rulesConfigurationFile = null;

    LanguageToolHttpHandler(boolean verbose, Set<String> allowedIps, boolean internal, RequestLimiter requestLimiter, LinkedBlockingQueue<Runnable> workQueue) {
        this.verbose = verbose;
        this.allowedIps = allowedIps;
        this.internalServer = internal;
        this.requestLimiter = requestLimiter;
        this.workQueue = workQueue;
        this.executorService = Executors.newCachedThreadPool();
        this.identifier = new LanguageIdentifier();
    }

    void shutdown() {
        this.executorService.shutdownNow();
    }

    void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    void setMaxCheckTimeMillis(long maxCheckTimeMillis) {
        this.maxCheckTimeMillis = maxCheckTimeMillis;
    }

    void setTrustXForwardForHeader(boolean trustXForwardForHeader) {
        this.trustXForwardForHeader = trustXForwardForHeader;
        if (trustXForwardForHeader) {
            this.ownIps = this.getServersOwnIps();
        }
    }

    void setAllowOriginUrl(String allowOriginUrl) {
        this.allowOriginUrl = allowOriginUrl;
    }

    void setAfterTheDeadlineMode(Language defaultLanguage) {
        System.out.println("Running in After the Deadline mode, default language: " + defaultLanguage);
        this.afterTheDeadlineMode = true;
        this.afterTheDeadlineLanguage = defaultLanguage;
    }

    void setLanguageModel(File languageModelDir) {
        this.languageModelDir = languageModelDir;
    }

    void setMaxWorkQueueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Max queue size must be >= 0: " + size);
        }
        this.maxWorkQueueSize = size;
    }

    void setRulesConfigurationFile(File configFile) {
        this.rulesConfigurationFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        block39: {
            LanguageToolHttpHandler languageToolHttpHandler = this;
            synchronized (languageToolHttpHandler) {
                ++handleCount;
            }
            String text = null;
            try {
                URI requestedUri = httpExchange.getRequestURI();
                String origAddress = httpExchange.getRemoteAddress().getAddress().getHostAddress();
                String realAddressOrNull = this.getRealRemoteAddressOrNull(httpExchange);
                String remoteAddress = realAddressOrNull != null ? realAddressOrNull : origAddress;
                Map<String, String> parameters = this.getRequestQuery(httpExchange, requestedUri);
                if (this.requestLimiter != null && !this.requestLimiter.isAccessOkay(remoteAddress)) {
                    String errorMessage = "Error: Access from " + remoteAddress + " denied - too many requests. Allowed maximum requests: " + this.requestLimiter.getRequestLimit() + " requests per " + this.requestLimiter.getRequestLimitPeriodInSeconds() + " seconds";
                    this.sendError(httpExchange, 403, errorMessage);
                    LanguageToolHttpHandler.print(errorMessage);
                    return;
                }
                if (this.maxWorkQueueSize != 0 && this.workQueue.size() > this.maxWorkQueueSize) {
                    String response = "Error: There are currently too many parallel requests. Please try again later.";
                    LanguageToolHttpHandler.print(response + " Queue size: " + this.workQueue.size() + ", maximum size: " + this.maxWorkQueueSize);
                    this.sendError(httpExchange, 503, "Error: " + response);
                    return;
                }
                if (this.allowedIps == null || this.allowedIps.contains(origAddress)) {
                    if (requestedUri.getRawPath().endsWith("/Languages")) {
                        this.printListOfLanguages(httpExchange);
                    } else {
                        if (this.afterTheDeadlineMode) {
                            text = parameters.get("data");
                            if (text == null) {
                                throw new IllegalArgumentException("Missing 'data' parameter");
                            }
                            text = text.replaceAll("</p>", "\n\n").replaceAll("<.*?>", "");
                        } else {
                            text = parameters.get("text");
                            if (text == null) {
                                throw new IllegalArgumentException("Missing 'text' parameter");
                            }
                        }
                        this.checkText(text, httpExchange, parameters);
                    }
                    break block39;
                }
                String errorMessage = "Error: Access from " + StringTools.escapeXML((String)origAddress) + " denied";
                this.sendError(httpExchange, 403, errorMessage);
                throw new RuntimeException(errorMessage);
            }
            catch (Exception e) {
                String response;
                int errorCode;
                LanguageToolHttpHandler.print("An error has occurred. Stacktrace follows:", System.err);
                if (this.verbose && text != null) {
                    LanguageToolHttpHandler.print("Exception was caused by this text (" + text.length() + " chars, showing up to 500):\n" + StringUtils.abbreviate((String)text, (int)500), System.err);
                }
                e.printStackTrace();
                if (e instanceof TextTooLongException) {
                    errorCode = 413;
                    response = e.getMessage();
                } else if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                    errorCode = 503;
                    response = "Checking took longer than " + this.maxCheckTimeMillis / 1000L + " seconds, which is this server's limit. " + "Please make sure you have selected the proper language or consider submitting a shorter text.";
                } else {
                    response = Tools.getFullStackTrace((Throwable)e);
                    errorCode = 500;
                }
                this.sendError(httpExchange, errorCode, "Error: " + response);
            }
            finally {
                LanguageToolHttpHandler languageToolHttpHandler2 = this;
                synchronized (languageToolHttpHandler2) {
                    --handleCount;
                }
                httpExchange.close();
            }
        }
    }

    private Set<String> getServersOwnIps() {
        HashSet<String> ownIps = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface netInterface = e.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    ownIps.add(address.getHostAddress());
                }
            }
        }
        catch (SocketException e1) {
            throw new RuntimeException("Could not get the servers own IP addresses", e1);
        }
        return ownIps;
    }

    @Nullable
    private String getRealRemoteAddressOrNull(HttpExchange httpExchange) {
        Object forwardedIpsStr;
        if (this.trustXForwardForHeader && (forwardedIpsStr = httpExchange.getRequestHeaders().get("X-forwarded-for")) != null) {
            String allForwardedIpsStr = StringUtils.join((Collection)forwardedIpsStr, (String)", ");
            List<String> allForwardedIps = Arrays.asList(allForwardedIpsStr.split(", "));
            return this.getLastIpIgnoringOwn(allForwardedIps);
        }
        return null;
    }

    private String getLastIpIgnoringOwn(List<String> forwardedIps) {
        String lastIp = null;
        for (String ip : forwardedIps) {
            if (this.ownIps.contains(ip)) continue;
            lastIp = ip;
        }
        return lastIp;
    }

    private void sendError(HttpExchange httpExchange, int httpReturnCode, String response) throws IOException {
        if (this.afterTheDeadlineMode) {
            String xmlResponse = "<results><message>" + StringTools.escapeForXmlContent((String)response) + "</message></results>";
            httpExchange.sendResponseHeaders(httpReturnCode, xmlResponse.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(xmlResponse.getBytes(ENCODING));
        } else {
            httpExchange.sendResponseHeaders(httpReturnCode, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        }
    }

    private Map<String, String> getRequestQuery(HttpExchange httpExchange, URI requestedUri) throws IOException {
        String query = "post".equalsIgnoreCase(httpExchange.getRequestMethod()) ? StringTools.streamToString((InputStream)httpExchange.getRequestBody(), (String)ENCODING) : requestedUri.getRawQuery();
        return this.parseQuery(query);
    }

    private void printListOfLanguages(HttpExchange httpExchange) throws IOException {
        this.setCommonHeaders(httpExchange);
        String response = LanguageToolHttpHandler.getSupportedLanguagesAsXML();
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private void setCommonHeaders(HttpExchange httpExchange) {
        httpExchange.getResponseHeaders().set("Content-Type", CONTENT_TYPE_VALUE);
        if (this.allowOriginUrl != null) {
            httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", this.allowOriginUrl);
        }
    }

    private Language detectLanguageOfString(String text, String fallbackLanguage) {
        Language lang = this.identifier.detectLanguage(text);
        if (lang == null) {
            lang = Languages.getLanguageForShortName((String)(fallbackLanguage != null ? fallbackLanguage : "en"));
        }
        if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return lang;
    }

    private void checkText(final String text, HttpExchange httpExchange, final Map<String, String> parameters) throws Exception {
        List<RuleMatch> matches;
        long timeStart = System.currentTimeMillis();
        if (text.length() > this.maxTextLength) {
            throw new TextTooLongException("Your text exceeds this server's limit of " + this.maxTextLength + " characters (it's " + text.length() + " characters). Please submit a shorter text.");
        }
        boolean autoDetectLanguage = this.getLanguageAutoDetect(parameters);
        final Language lang = this.getLanguage(text, parameters.get("language"), autoDetectLanguage);
        String motherTongueParam = parameters.get("motherTongue");
        final Language motherTongue = motherTongueParam != null ? Languages.getLanguageForShortName((String)motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(parameters.get("enabledOnly"));
        String enabledParam = parameters.get("enabled");
        ArrayList<String> enabledRules = new ArrayList<String>();
        if (enabledParam != null) {
            enabledRules.addAll(Arrays.asList(enabledParam.split(",")));
        }
        String disabledParam = parameters.get("disabled");
        ArrayList<String> disabledRules = new ArrayList<String>();
        if (disabledParam != null) {
            disabledRules.addAll(Arrays.asList(disabledParam.split(",")));
        }
        if (disabledRules.size() > 0 && useEnabledOnly) {
            throw new IllegalArgumentException("You cannot specify disabled rules using enabledOnly=yes");
        }
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0;
        final QueryParams params = new QueryParams(enabledRules, disabledRules, useEnabledOnly, useQuerySettings);
        Future<List<RuleMatch>> future = this.executorService.submit(new Callable<List<RuleMatch>>(){

            @Override
            public List<RuleMatch> call() throws Exception {
                return LanguageToolHttpHandler.this.getRuleMatches(text, parameters, lang, motherTongue, params);
            }
        });
        if (this.maxCheckTimeMillis < 0L) {
            matches = future.get();
        } else {
            try {
                matches = future.get(this.maxCheckTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Text checking took longer than allowed maximum of " + this.maxCheckTimeMillis + " milliseconds (handleCount: " + handleCount + ", queue size: " + this.workQueue.size() + ", language: " + lang.getShortNameWithCountryAndVariant() + ", " + text.length() + " characters of text)", e);
            }
        }
        this.setCommonHeaders(httpExchange);
        String xmlResponse = this.getXmlResponse(text, lang, motherTongue, matches);
        String messageSent = "sent";
        String languageMessage = lang.getShortNameWithCountryAndVariant();
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        try {
            httpExchange.sendResponseHeaders(200, xmlResponse.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(xmlResponse.getBytes(ENCODING));
            if (motherTongue != null) {
                languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortNameWithCountryAndVariant() + ")";
            }
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        String agent = parameters.get("useragent") != null ? parameters.get("useragent") : "-";
        LanguageToolHttpHandler.print("Check done: " + text.length() + " chars, " + languageMessage + ", " + referrer + ", " + "handlers:" + handleCount + ", queue:" + this.workQueue.size() + ", " + matches.size() + " matches, " + (System.currentTimeMillis() - timeStart) + "ms, agent:" + agent + ", " + messageSent);
    }

    private boolean getLanguageAutoDetect(Map<String, String> parameters) {
        if (this.afterTheDeadlineMode) {
            return "true".equals(parameters.get("guess"));
        }
        boolean autoDetect = "1".equals(parameters.get("autodetect"));
        if (parameters.get("language") == null && !autoDetect) {
            throw new IllegalArgumentException("Missing 'language' parameter. Specify language or use autodetect=1 for auto-detecting the language of the input text.");
        }
        return autoDetect;
    }

    private Language getLanguage(String text, String langParam, boolean autoDetect) {
        Language lang;
        if (autoDetect) {
            lang = this.detectLanguageOfString(text, langParam);
            LanguageToolHttpHandler.print("Auto-detected language: " + lang.getShortNameWithCountryAndVariant());
        } else {
            lang = this.afterTheDeadlineMode ? this.afterTheDeadlineLanguage : Languages.getLanguageForShortName((String)langParam);
        }
        return lang;
    }

    private List<RuleMatch> getRuleMatches(String text, Map<String, String> parameters, Language lang, Language motherTongue, QueryParams params) throws Exception {
        String sourceText = parameters.get("srctext");
        if (sourceText == null) {
            JLanguageTool lt = this.getLanguageToolInstance(lang, motherTongue, params);
            return lt.check(text);
        }
        if (parameters.get("motherTongue") == null) {
            throw new IllegalArgumentException("Missing 'motherTongue' parameter for bilingual checks");
        }
        LanguageToolHttpHandler.print("Checking bilingual text, with source length " + sourceText.length() + " and target length " + text.length() + " (characters), source language " + motherTongue + " and target language " + lang.getShortNameWithCountryAndVariant());
        JLanguageTool sourceLt = this.getLanguageToolInstance(motherTongue, null, params);
        JLanguageTool targetLt = this.getLanguageToolInstance(lang, null, params);
        List bRules = Tools.selectBitextRules((List)Tools.getBitextRules((Language)motherTongue, (Language)lang), params.disabledRules, params.enabledRules, (boolean)params.useEnabledOnly);
        return Tools.checkBitext((String)sourceText, (String)text, (JLanguageTool)sourceLt, (JLanguageTool)targetLt, (List)bRules);
    }

    private String getXmlResponse(String text, Language lang, Language motherTongue, List<RuleMatch> matches) {
        if (this.afterTheDeadlineMode) {
            AtDXmlSerializer serializer = new AtDXmlSerializer();
            return serializer.ruleMatchesToXml(matches, text);
        }
        RuleMatchAsXmlSerializer serializer = new RuleMatchAsXmlSerializer();
        return serializer.ruleMatchesToXml(matches, text, 40, lang, motherTongue);
    }

    private Map<String, String> parseQuery(String query) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            String[] pairs = query.split("[&]");
            Map<String, String> parameterMap = this.getParameterMap(pairs);
            parameters.putAll(parameterMap);
        }
        return parameters;
    }

    private Map<String, String> getParameterMap(String[] pairs) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            int delimPos = pair.indexOf(61);
            if (delimPos == -1) continue;
            String param = pair.substring(0, delimPos);
            String key = URLDecoder.decode(param, ENCODING);
            String value = URLDecoder.decode(pair.substring(delimPos + 1), ENCODING);
            parameters.put(key, value);
        }
        return parameters;
    }

    private static void print(String s) {
        LanguageToolHttpHandler.print(s, System.out);
    }

    private static void print(String s, PrintStream outputStream) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = dateFormat.format(new Date());
        outputStream.println(now + " " + s);
    }

    private JLanguageTool getLanguageToolInstance(Language lang, Language motherTongue, QueryParams params) throws Exception {
        JLanguageTool newLanguageTool = new JLanguageTool(lang, motherTongue);
        if (this.languageModelDir != null) {
            newLanguageTool.activateLanguageModelRules(this.languageModelDir);
        }
        if (!params.useQuerySettings) {
            if (this.rulesConfigurationFile != null) {
                this.configureFromRulesFile(newLanguageTool, lang);
            } else {
                this.configureFromGUI(newLanguageTool, lang);
            }
        }
        if (params.useQuerySettings) {
            Tools.selectRules((JLanguageTool)newLanguageTool, params.disabledRules, params.enabledRules, (boolean)params.useEnabledOnly);
        }
        return newLanguageTool;
    }

    private void configureFromRulesFile(JLanguageTool langTool, Language lang) throws IOException {
        LanguageToolHttpHandler.print("Using options configured in " + this.rulesConfigurationFile);
        this.configureFromRules(langTool, new Configuration(this.rulesConfigurationFile.getParentFile(), this.rulesConfigurationFile.getName(), lang));
    }

    private void configureFromGUI(JLanguageTool langTool, Language lang) throws IOException {
        Configuration config = new Configuration(lang);
        if (this.internalServer && config.getUseGUIConfig()) {
            LanguageToolHttpHandler.print("Using options configured in the GUI");
            this.configureFromRules(langTool, config);
        }
    }

    private void configureFromRules(JLanguageTool langTool, Configuration config) {
        Set enabledRules;
        Set disabledCategories;
        Set disabledRules = config.getDisabledRuleIds();
        if (disabledRules != null) {
            for (Object ruleId : disabledRules) {
                langTool.disableRule((String)ruleId);
            }
        }
        if ((disabledCategories = config.getDisabledCategoryNames()) != null) {
            for (String categoryName : disabledCategories) {
                langTool.disableCategory(categoryName);
            }
        }
        if ((enabledRules = config.getEnabledRuleIds()) != null) {
            for (String ruleName : enabledRules) {
                langTool.enableDefaultOffRule(ruleName);
                langTool.enableRule(ruleName);
            }
        }
    }

    public static String getSupportedLanguagesAsXML() {
        ArrayList languages = new ArrayList(Languages.get());
        Collections.sort(languages, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        StringBuilder xmlBuffer = new StringBuilder("<?xml version='1.0' encoding='utf-8'?>\n<languages>\n");
        for (Language lang : languages) {
            xmlBuffer.append(String.format("\t<language name=\"%s\" abbr=\"%s\" abbrWithVariant=\"%s\"/> \n", lang.getName(), lang.getShortName(), lang.getShortNameWithCountryAndVariant()));
        }
        xmlBuffer.append("</languages>\n");
        return xmlBuffer.toString();
    }

    private class QueryParams {
        final List<String> enabledRules;
        final List<String> disabledRules;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;

        QueryParams(List<String> enabledRules, List<String> disabledRules, boolean useEnabledOnly, boolean useQuerySettings) {
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
        }
    }
}

