/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpServer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.RequestLimiter;

abstract class Server {
    protected static final Set<String> DEFAULT_ALLOWED_IPS = new HashSet<String>(Arrays.asList("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1%0", "127.0.0.1"));
    static final int THREAD_POOL_SIZE = 10;
    protected int port;
    protected String host;
    protected HttpServer server;
    protected LanguageToolHttpHandler httpHandler;
    private boolean isRunning;

    Server() {
    }

    protected abstract String getProtocol();

    public void run() {
        String hostName = this.host != null ? this.host : "localhost";
        System.out.println("Starting LanguageTool 2.9 (build date: " + JLanguageTool.BUILD_DATE + ") server on " + this.getProtocol() + "://" + hostName + ":" + this.port + "...");
        this.server.start();
        this.isRunning = true;
        System.out.println("Server started");
    }

    public void stop() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
        }
        if (this.server != null) {
            System.out.println("Stopping server");
            this.server.stop(0);
            this.isRunning = false;
            System.out.println("Server stopped");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    protected RequestLimiter getRequestLimiterOrNull(HTTPServerConfig config) {
        int requestLimit = config.getRequestLimit();
        int requestLimitPeriodInSeconds = config.getRequestLimitPeriodInSeconds();
        if (requestLimit > 0 || requestLimitPeriodInSeconds > 0) {
            return new RequestLimiter(requestLimit, requestLimitPeriodInSeconds);
        }
        return null;
    }

    protected static boolean usageRequested(String[] args) {
        return args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"));
    }

    protected static void printCommonConfigFileOptions() {
        System.out.println("                 'mode' - 'LanguageTool' or 'AfterTheDeadline' for emulation of After the Deadline output (optional, experimental)");
        System.out.println("                 'afterTheDeadlineLanguage' - language code like 'en' or 'en-GB' (required if mode is 'AfterTheDeadline')");
        System.out.println("                 'maxTextLength' - maximum text length, longer texts will cause an error (optional)");
        System.out.println("                 'maxCheckTimeMillis' - maximum time in milliseconds allowed per check (optional)");
        System.out.println("                 'maxCheckThreads' - maximum number of threads working in parallel (optional)");
        System.out.println("                 'requestLimit' - maximum number of requests (optional)");
        System.out.println("                 'requestLimitPeriodInSeconds' - time period to which requestLimit applies (optional)");
        System.out.println("                 'languageModel' - a directory with a '3grams' sub directory with a Lucene index that");
        System.out.println("                  contains ngram occurrence counts; activates the confusion rule if supported (optional)");
        System.out.println("                 'maxWorkQueueSize' - reject request if request queue gets larger than this (optional)");
    }

    protected static void printCommonOptions() {
        System.out.println("  --port, -p     port to bind to, defaults to 8081 if not specified");
        System.out.println("  --public       allow this server process to be connected from anywhere; if not set,");
        System.out.println("                 it can only be connected from the computer it was started on");
        System.out.println("  --allow-origin ORIGIN  set the Access-Control-Allow-Origin header in the HTTP response,");
        System.out.println("                         used for direct (non-proxy) JavaScript-based access from browsers;");
        System.out.println("                         example: --allow-origin \"*\"");
        System.out.println("  --verbose, -v  in case of exceptions, log the input text (up to 500 characters)");
    }

    protected ThreadPoolExecutor getExecutorService(LinkedBlockingQueue<Runnable> workQueue, HTTPServerConfig config) {
        int threadPoolSize = config.getMaxCheckThreads();
        System.out.println("Setting up thread pool with " + threadPoolSize + " threads");
        return new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, workQueue);
    }
}

