/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tika.language.LanguageIdentifier;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.RequestLimiter;
import org.languagetool.tools.RuleAsXmlSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

class LanguageToolHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_VALUE = "text/xml; charset=UTF-8";
    private static final String ENCODING = "utf-8";
    private static final int CONTEXT_SIZE = 40;
    private static final int MIN_LENGTH_FOR_AUTO_DETECTION = 60;
    private final Set<String> allowedIps;
    private final boolean verbose;
    private final boolean internalServer;
    private final RequestLimiter requestLimiter;
    private final ExecutorService executorService;
    private long maxCheckTimeMillis = -1L;
    private int maxTextLength = Integer.MAX_VALUE;
    private String allowOriginUrl;
    private static int handleCount = 0;

    LanguageToolHttpHandler(boolean verbose, Set<String> allowedIps, boolean internal, RequestLimiter requestLimiter) {
        this.verbose = verbose;
        this.allowedIps = allowedIps;
        this.internalServer = internal;
        this.requestLimiter = requestLimiter;
        this.executorService = Executors.newCachedThreadPool();
    }

    void shutdown() {
        this.executorService.shutdownNow();
    }

    void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    void setMaxCheckTimeMillis(long maxCheckTimeMillis) {
        this.maxCheckTimeMillis = maxCheckTimeMillis;
    }

    void setAllowOriginUrl(String allowOriginUrl) {
        this.allowOriginUrl = allowOriginUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        block27: {
            LanguageToolHttpHandler languageToolHttpHandler = this;
            synchronized (languageToolHttpHandler) {
                ++handleCount;
            }
            String text = null;
            try {
                URI requestedUri = httpExchange.getRequestURI();
                String remoteAddress = httpExchange.getRemoteAddress().getAddress().getHostAddress();
                Map<String, String> parameters = this.getRequestQuery(httpExchange, requestedUri);
                if (this.requestLimiter != null && !this.requestLimiter.isAccessOkay(remoteAddress)) {
                    String errorMessage = "Error: Access from " + StringTools.escapeXML((String)remoteAddress) + " denied - too many requests. Allowed maximum requests: " + this.requestLimiter.getRequestLimit() + " requests per " + this.requestLimiter.getRequestLimitPeriodInSeconds() + " seconds";
                    this.sendError(httpExchange, 403, errorMessage);
                    LanguageToolHttpHandler.print(errorMessage);
                    return;
                }
                if (this.allowedIps == null || this.allowedIps.contains(remoteAddress)) {
                    if (requestedUri.getRawPath().endsWith("/Languages")) {
                        this.printListOfLanguages(httpExchange);
                    } else {
                        text = parameters.get("text");
                        if (text == null) {
                            throw new IllegalArgumentException("Missing 'text' parameter");
                        }
                        this.checkText(text, httpExchange, parameters);
                    }
                    break block27;
                }
                String errorMessage = "Error: Access from " + StringTools.escapeXML((String)remoteAddress) + " denied";
                this.sendError(httpExchange, 403, errorMessage);
                throw new RuntimeException(errorMessage);
            }
            catch (Exception e) {
                LanguageToolHttpHandler.print("An error has occurred. Stacktrace follows:", System.err);
                if (this.verbose) {
                    LanguageToolHttpHandler.print("Exception was caused by this text: " + text, System.err);
                }
                e.printStackTrace();
                String response = "Error: " + StringTools.escapeXML((String)Tools.getFullStackTrace((Throwable)e));
                this.sendError(httpExchange, 500, response);
            }
            finally {
                LanguageToolHttpHandler languageToolHttpHandler2 = this;
                synchronized (languageToolHttpHandler2) {
                    --handleCount;
                }
                httpExchange.close();
            }
        }
    }

    private void sendError(HttpExchange httpExchange, int returnCode, String response) throws IOException {
        httpExchange.sendResponseHeaders(returnCode, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private Map<String, String> getRequestQuery(HttpExchange httpExchange, URI requestedUri) throws IOException {
        String query = "post".equalsIgnoreCase(httpExchange.getRequestMethod()) ? StringTools.streamToString((InputStream)httpExchange.getRequestBody(), (String)ENCODING) : requestedUri.getRawQuery();
        return this.parseQuery(query);
    }

    private void printListOfLanguages(HttpExchange httpExchange) throws IOException {
        this.setCommonHeaders(httpExchange);
        String response = LanguageToolHttpHandler.getSupportedLanguagesAsXML();
        httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private void setCommonHeaders(HttpExchange httpExchange) {
        httpExchange.getResponseHeaders().set("Content-Type", CONTENT_TYPE_VALUE);
        if (this.allowOriginUrl != null) {
            httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", this.allowOriginUrl);
        }
    }

    private static Language detectLanguageOfString(String text, String fallbackLanguage) {
        Language lang;
        if (text.length() < 60 && fallbackLanguage != null) {
            LanguageToolHttpHandler.print("Auto-detected language of text with length " + text.length() + " is not reasonably certain, using '" + fallbackLanguage + "' as fallback");
            return Language.getLanguageForShortName((String)fallbackLanguage);
        }
        LanguageIdentifier identifier = new LanguageIdentifier(text);
        try {
            lang = Language.getLanguageForShortName((String)identifier.getLanguage());
        }
        catch (IllegalArgumentException e) {
            lang = Language.getLanguageForLocale((Locale)Locale.ENGLISH);
        }
        if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return lang;
    }

    private void checkText(final String text, HttpExchange httpExchange, final Map<String, String> parameters) throws Exception {
        List<RuleMatch> matches;
        Language lang;
        long timeStart = System.currentTimeMillis();
        if (text.length() > this.maxTextLength) {
            throw new IllegalArgumentException("Text is " + text.length() + " characters long, exceeding maximum length of " + this.maxTextLength);
        }
        String langParam = parameters.get("language");
        String autodetectParam = parameters.get("autodetect");
        if (!(langParam != null || autodetectParam != null && autodetectParam.equals("1"))) {
            throw new IllegalArgumentException("Missing 'language' parameter. Specify language or use autodetect=1 for auto-detecting the language of the input text.");
        }
        if (autodetectParam != null && autodetectParam.equals("1")) {
            lang = LanguageToolHttpHandler.detectLanguageOfString(text, langParam);
            LanguageToolHttpHandler.print("Auto-detected language: " + lang.getShortNameWithCountryAndVariant());
        } else {
            lang = Language.getLanguageForShortName((String)langParam);
        }
        String motherTongueParam = parameters.get("motherTongue");
        final Language motherTongue = motherTongueParam != null ? Language.getLanguageForShortName((String)motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(parameters.get("enabledOnly"));
        String enabledParam = parameters.get("enabled");
        ArrayList<String> enabledRules = new ArrayList<String>();
        if (enabledParam != null) {
            enabledRules.addAll(Arrays.asList(enabledParam.split(",")));
        }
        String disabledParam = parameters.get("disabled");
        ArrayList<String> disabledRules = new ArrayList<String>();
        if (disabledParam != null) {
            disabledRules.addAll(Arrays.asList(disabledParam.split(",")));
        }
        if (disabledRules.size() > 0 && useEnabledOnly) {
            throw new IllegalArgumentException("You cannot specify disabled rules using enabledOnly=yes");
        }
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0;
        final QueryParams params = new QueryParams(enabledRules, disabledRules, useEnabledOnly, useQuerySettings);
        Future<List<RuleMatch>> future = this.executorService.submit(new Callable<List<RuleMatch>>(){

            @Override
            public List<RuleMatch> call() throws Exception {
                return LanguageToolHttpHandler.this.getRuleMatches(text, parameters, lang, motherTongue, params);
            }
        });
        if (this.maxCheckTimeMillis < 0L) {
            matches = future.get();
        } else {
            try {
                matches = future.get(this.maxCheckTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Text checking took longer than allowed maximum of " + this.maxCheckTimeMillis + " milliseconds (handleCount: " + handleCount + ", language: " + lang.getShortNameWithCountryAndVariant() + ", " + text.length() + " characters of text)", e);
            }
        }
        this.setCommonHeaders(httpExchange);
        RuleAsXmlSerializer serializer = new RuleAsXmlSerializer();
        String xmlResponse = serializer.ruleMatchesToXml(matches, text, 40, lang, motherTongue);
        String messageSent = "sent";
        String languageMessage = lang.getShortNameWithCountryAndVariant();
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        try {
            httpExchange.sendResponseHeaders(200, xmlResponse.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(xmlResponse.getBytes(ENCODING));
            if (motherTongue != null) {
                languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortNameWithCountryAndVariant() + ")";
            }
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        LanguageToolHttpHandler.print("Check done: " + text.length() + " chars, " + languageMessage + ", " + referrer + ", " + "handlers:" + handleCount + ", " + matches.size() + " matches, " + (System.currentTimeMillis() - timeStart) + "ms" + ", " + messageSent);
    }

    private List<RuleMatch> getRuleMatches(String text, Map<String, String> parameters, Language lang, Language motherTongue, QueryParams params) throws Exception {
        String sourceText = parameters.get("srctext");
        if (sourceText == null) {
            JLanguageTool lt = this.getLanguageToolInstance(lang, motherTongue, params);
            return lt.check(text);
        }
        if (parameters.get("motherTongue") == null) {
            throw new IllegalArgumentException("Missing 'motherTongue' parameter for bilingual checks");
        }
        LanguageToolHttpHandler.print("Checking bilingual text, with source length " + sourceText.length() + " and target length " + text.length() + " (characters), source language " + motherTongue + " and target language " + lang.getShortNameWithCountryAndVariant());
        JLanguageTool sourceLt = this.getLanguageToolInstance(motherTongue, null, params);
        JLanguageTool targetLt = this.getLanguageToolInstance(lang, null, params);
        List bRules = Tools.getBitextRules((Language)motherTongue, (Language)lang);
        return Tools.checkBitext((String)sourceText, (String)text, (JLanguageTool)sourceLt, (JLanguageTool)targetLt, (List)bRules);
    }

    private Map<String, String> parseQuery(String query) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            String[] pairs = query.split("[&]");
            Map<String, String> parameterMap = this.getParameterMap(pairs);
            parameters.putAll(parameterMap);
        }
        return parameters;
    }

    private Map<String, String> getParameterMap(String[] pairs) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            int delimPos = pair.indexOf(61);
            if (delimPos == -1) continue;
            String param = pair.substring(0, delimPos);
            String key = URLDecoder.decode(param, ENCODING);
            String value = URLDecoder.decode(pair.substring(delimPos + 1), ENCODING);
            parameters.put(key, value);
        }
        return parameters;
    }

    private static void print(String s) {
        LanguageToolHttpHandler.print(s, System.out);
    }

    private static void print(String s, PrintStream outputStream) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = dateFormat.format(new Date());
        outputStream.println(now + " " + s);
    }

    private JLanguageTool getLanguageToolInstance(Language lang, Language motherTongue, QueryParams params) throws Exception {
        JLanguageTool newLanguageTool = new JLanguageTool(lang, motherTongue);
        newLanguageTool.activateDefaultPatternRules();
        newLanguageTool.activateDefaultFalseFriendRules();
        Configuration config = new Configuration(lang);
        if (!params.useQuerySettings && this.internalServer && config.getUseGUIConfig()) {
            this.configureGUI(newLanguageTool, config);
        }
        if (params.useQuerySettings) {
            Tools.selectRules((JLanguageTool)newLanguageTool, params.disabledRules, params.enabledRules, (boolean)params.useEnabledOnly);
        }
        return newLanguageTool;
    }

    private void configureGUI(JLanguageTool langTool, Configuration config) {
        Set enabledRules;
        Set disabledCategories;
        LanguageToolHttpHandler.print("Using options configured in the GUI");
        Set disabledRules = config.getDisabledRuleIds();
        if (disabledRules != null) {
            for (String ruleId : disabledRules) {
                langTool.disableRule(ruleId);
            }
        }
        if ((disabledCategories = config.getDisabledCategoryNames()) != null) {
            for (String categoryName : disabledCategories) {
                langTool.disableCategory(categoryName);
            }
        }
        if ((enabledRules = config.getEnabledRuleIds()) != null) {
            for (String ruleName : enabledRules) {
                langTool.enableDefaultOffRule(ruleName);
                langTool.enableRule(ruleName);
            }
        }
    }

    public static String getSupportedLanguagesAsXML() {
        Language[] languageCopy = (Language[])Language.REAL_LANGUAGES.clone();
        List<Language> languages = Arrays.asList(languageCopy);
        Collections.sort(languages, new Comparator<Language>(){

            @Override
            public int compare(Language o1, Language o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder xmlBuffer = new StringBuilder("<?xml version='1.0' encoding='utf-8'?>\n<languages>\n");
        for (Language lang : languages) {
            xmlBuffer.append(String.format("\t<language name=\"%s\" abbr=\"%s\" abbrWithVariant=\"%s\"/> \n", lang.getName(), lang.getShortName(), lang.getShortNameWithCountryAndVariant()));
        }
        xmlBuffer.append("</languages>\n");
        return xmlBuffer.toString();
    }

    private class QueryParams {
        final List<String> enabledRules;
        final List<String> disabledRules;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;

        QueryParams(List<String> enabledRules, List<String> disabledRules, boolean useEnabledOnly, boolean useQuerySettings) {
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
        }
    }
}

