/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.languagetool.server.IllegalConfigurationException;

public class HTTPServerConfig {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8081;
    protected boolean verbose = false;
    protected boolean publicAccess = false;
    protected int port = 8081;
    protected String allowOriginUrl = null;
    protected int maxTextLength = Integer.MAX_VALUE;
    protected long maxCheckTimeMillis = -1L;

    public HTTPServerConfig() {
        this.port = 8081;
        this.verbose = false;
        this.publicAccess = false;
    }

    public HTTPServerConfig(int serverPort, boolean verbose) {
        this.port = serverPort;
        this.verbose = verbose;
        this.publicAccess = false;
    }

    HTTPServerConfig(String[] args) {
        block16: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--config": {
                    this.parseConfigFile(new File(args[++i]));
                    continue block16;
                }
                case "-p": 
                case "--port": {
                    this.port = Integer.parseInt(args[++i]);
                    continue block16;
                }
                case "-v": 
                case "--verbose": {
                    this.verbose = true;
                    continue block16;
                }
                case "--public": {
                    this.publicAccess = true;
                    continue block16;
                }
                case "--allow-origin": {
                    this.allowOriginUrl = args[++i];
                }
            }
        }
    }

    private void parseConfigFile(File file) {
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                props.load(fis);
                this.maxTextLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextLength", Integer.toString(Integer.MAX_VALUE)));
                this.maxCheckTimeMillis = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillis", "-1"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties from '" + file + "'", e);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public int getPort() {
        return this.port;
    }

    public String getAllowOriginUrl() {
        return this.allowOriginUrl;
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    void setMaxCheckTimeMillis(int maxCheckTimeMillis) {
        this.maxCheckTimeMillis = maxCheckTimeMillis;
    }

    long getMaxCheckTimeMillis() {
        return this.maxCheckTimeMillis;
    }

    protected String getProperty(Properties props, String propertyName, File config) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            throw new IllegalConfigurationException("Property '" + propertyName + "' must be set in " + config);
        }
        return propertyValue;
    }

    protected String getOptionalProperty(Properties props, String propertyName, String defaultValue) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }
}

