/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpServer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.languagetool.JLanguageTool;

abstract class Server {
    protected static final Set<String> DEFAULT_ALLOWED_IPS = new HashSet<String>(Arrays.asList("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1%0", "127.0.0.1"));
    static final int THREAD_POOL_SIZE = 10;
    protected int port;
    protected String host;
    protected HttpServer server;
    private boolean isRunning;

    Server() {
    }

    protected abstract String getProtocol();

    public void run() {
        String hostName = this.host != null ? this.host : "localhost";
        System.out.println("Starting LanguageTool 2.4 (build date: " + JLanguageTool.BUILD_DATE + ") server on " + this.getProtocol() + "://" + hostName + ":" + this.port + "...");
        this.server.start();
        this.isRunning = true;
        System.out.println("Server started");
    }

    public void stop() {
        if (this.server != null) {
            System.out.println("Stopping server");
            this.server.stop(0);
            this.isRunning = false;
            System.out.println("Server stopped");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected static boolean usageRequested(String[] args) {
        return args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"));
    }

    protected static void printCommonOptions() {
        System.out.println("  --port, -p     port to bind to, defaults to 8081 if not specified");
        System.out.println("  --public       allow this server process to be connected from anywhere; if not set,");
        System.out.println("                 it can only be connected from the computer it was started on");
        System.out.println("  --allow-origin ORIGIN  set the Access-Control-Allow-Origin header in the HTTP response,");
        System.out.println("                         used for direct (non-proxy) JavaScript-based access from browsers;");
        System.out.println("                         example: --allow-origin \"*\"");
    }
}

