/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.languagetool.server.HTTPServerConfig;

public class HTTPSServerConfig
extends HTTPServerConfig {
    private final File keystore;
    private final String keyStorePassword;
    private int requestLimit;
    private int requestLimitPeriodInSeconds;
    private int maxTextLength = Integer.MAX_VALUE;

    public HTTPSServerConfig(File keystore, String keyStorePassword) {
        super(8081, false);
        this.keystore = keystore;
        this.keyStorePassword = keyStorePassword;
    }

    public HTTPSServerConfig(int serverPort, boolean verbose, File keystore, String keyStorePassword) {
        super(serverPort, verbose);
        this.keystore = keystore;
        this.keyStorePassword = keyStorePassword;
    }

    HTTPSServerConfig(int serverPort, boolean verbose, File keystore, String keyStorePassword, int requestLimit, int requestLimitPeriodInSeconds) {
        super(serverPort, verbose);
        this.keystore = keystore;
        this.keyStorePassword = keyStorePassword;
        this.requestLimit = requestLimit;
        this.requestLimitPeriodInSeconds = requestLimitPeriodInSeconds;
    }

    HTTPSServerConfig(String[] args) {
        super(args);
        File config = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"--config".equals(args[i])) continue;
            config = new File(args[++i]);
        }
        if (config == null) {
            throw new IllegalArgumentException("Parameter --config must be set and point to a property file");
        }
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(config);){
                props.load(fis);
                this.keystore = new File(this.getProperty(props, "keystore", config));
                this.keyStorePassword = this.getProperty(props, "password", config);
                this.requestLimit = Integer.parseInt(this.getOptionalProperty(props, "requestLimit", "0"));
                this.requestLimitPeriodInSeconds = Integer.parseInt(this.getOptionalProperty(props, "requestLimitPeriodInSeconds", "0"));
                this.maxTextLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextLength", Integer.toString(Integer.MAX_VALUE)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties from '" + config + "'", e);
        }
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    File getKeystore() {
        return this.keystore;
    }

    String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    private String getProperty(Properties props, String propertyName, File config) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            throw new IllegalArgumentException("Property '" + propertyName + "' must be set in " + config);
        }
        return propertyValue;
    }

    private String getOptionalProperty(Properties props, String propertyName, String defaultValue) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }
}

