/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

public class HTTPServerConfig {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8081;
    protected boolean verbose = false;
    protected boolean publicAccess = false;
    protected int port = 8081;
    protected String allowOriginUrl = null;

    public HTTPServerConfig() {
        this.port = 8081;
        this.verbose = false;
        this.publicAccess = false;
    }

    public HTTPServerConfig(int serverPort, boolean verbose) {
        this.port = serverPort;
        this.verbose = verbose;
        this.publicAccess = false;
    }

    HTTPServerConfig(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i]) || "--port".equals(args[i])) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-v".equals(args[i]) || "--verbose".equals(args[i])) {
                this.verbose = true;
                continue;
            }
            if ("--public".equals(args[i])) {
                this.publicAccess = true;
                continue;
            }
            if (!"--allow-origin".equals(args[i])) continue;
            this.allowOriginUrl = args[++i];
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public int getPort() {
        return this.port;
    }

    public String getAllowOriginUrl() {
        return this.allowOriginUrl;
    }
}

