/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.remote.RemoteServer;

public class RemoteResult {
    private final String language;
    private final String languageCode;
    private final String languageDetectedCode;
    private final String languageDetectedName;
    private final List<RemoteRuleMatch> matches;
    private final RemoteServer remoteServer;

    RemoteResult(String language, String languageCode, @Nullable String languageDetectedCode, @Nullable String languageDetectedName, List<RemoteRuleMatch> matches, RemoteServer remoteServer) {
        this.language = Objects.requireNonNull(language);
        this.languageCode = Objects.requireNonNull(languageCode);
        this.languageDetectedCode = languageDetectedCode;
        this.languageDetectedName = languageDetectedName;
        this.matches = Collections.unmodifiableList(Objects.requireNonNull(matches));
        this.remoteServer = Objects.requireNonNull(remoteServer);
    }

    public List<RemoteRuleMatch> getMatches() {
        return this.matches;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public RemoteServer getRemoteServer() {
        return this.remoteServer;
    }

    @Nullable
    public String getLanguageDetectedCode() {
        return this.languageDetectedCode;
    }

    @Nullable
    public String getLanguageDetectedName() {
        return this.languageDetectedName;
    }

    public String toString() {
        return this.matches.toString();
    }
}

