/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CheckConfiguration {
    private final String langCode;
    private final String motherTongueLangCode;
    private final boolean guessLanguage;
    private final List<String> enabledRuleIds;
    private final boolean enabledOnly;
    private final List<String> disabledRuleIds;
    private final String mode;
    private final String level;
    private final List<String> ruleValues;

    CheckConfiguration(String langCode, String motherTongueLangCode, boolean guessLanguage, List<String> enabledRuleIds, boolean enabledOnly, List<String> disabledRuleIds, String mode, String level, List<String> ruleValues) {
        if (langCode == null && !guessLanguage) {
            throw new IllegalArgumentException("No language was set but language guessing was not activated either");
        }
        if (langCode != null && guessLanguage) {
            throw new IllegalArgumentException("Language was set but language guessing was also activated");
        }
        this.langCode = langCode;
        this.motherTongueLangCode = motherTongueLangCode;
        this.guessLanguage = guessLanguage;
        this.enabledRuleIds = Objects.requireNonNull(enabledRuleIds);
        this.enabledOnly = enabledOnly;
        this.disabledRuleIds = Objects.requireNonNull(disabledRuleIds);
        this.mode = mode;
        this.level = level;
        this.ruleValues = Objects.requireNonNull(ruleValues);
    }

    public Optional<String> getLangCode() {
        return Optional.ofNullable(this.langCode);
    }

    public String getMotherTongueLangCode() {
        return this.motherTongueLangCode;
    }

    public boolean guessLanguage() {
        return this.guessLanguage;
    }

    public List<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public boolean enabledOnly() {
        return this.enabledOnly;
    }

    public List<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public String getMode() {
        return this.mode;
    }

    public String getLevel() {
        return this.level;
    }

    public List<String> getRuleValues() {
        return this.ruleValues;
    }
}

