/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.languagetool.tools.ContextTools;

public class Tools {
    private static final int DEFAULT_CONTEXT_SIZE = 40;
    private static final String MARKER_START = "<b><font bgcolor=\"#ff8b8b\">";
    private static final String MARKER_END = "</font></b>";

    private Tools() {
    }

    public static String makeTexti18n(ResourceBundle messages, String key, Object ... messageArguments) {
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(messages.getString(key).replaceAll("'", "''"));
        return formatter.format(messageArguments);
    }

    public static String getContext(int fromPos, int toPos, String text) {
        return Tools.getContext(fromPos, toPos, text, 40);
    }

    public static String getContext(int fromPos, int toPos, String fileContents, int contextSize) {
        return Tools.getContext(fromPos, toPos, fileContents, contextSize, MARKER_START, MARKER_END, true);
    }

    public static String getContext(int fromPos, int toPos, String fileContents, int contextSize, String markerStart, String markerEnd) {
        return Tools.getContext(fromPos, toPos, fileContents, contextSize, markerStart, markerEnd, false);
    }

    public static String getContext(int fromPos, int toPos, String text, int contextSize, String markerStart, String markerEnd, boolean escapeHTML) {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(contextSize);
        contextTools.setEscapeHtml(escapeHTML);
        contextTools.setErrorMarkerStart(markerStart);
        contextTools.setErrorMarkerEnd(markerEnd);
        return contextTools.getContext(fromPos, toPos, text);
    }

    static File openFileDialog(Frame frame, FileFilter fileFilter) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(fileFilter);
        jfc.showOpenDialog(frame);
        return jfc.getSelectedFile();
    }

    static void showError(Exception e) {
        String msg = org.languagetool.tools.Tools.getFullStackTrace((Throwable)e);
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
        e.printStackTrace();
    }

    static void showErrorMessage(Exception e) {
        String msg = e.getMessage();
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
        e.printStackTrace();
    }
}

