/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.CategoryComparator;
import org.languagetool.rules.Rule;
import org.languagetool.tools.StringTools;

public class ConfigurationDialog
implements ActionListener {
    private static final String NO_MOTHER_TONGUE = "---";
    private JButton okButton;
    private JButton cancelButton;
    private final ResourceBundle messages;
    private JDialog dialog;
    private JComboBox motherTongueBox;
    private JCheckBox serverCheckbox;
    private JTextField serverPortField;
    private final List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private final List<String> checkBoxesRuleIds = new ArrayList<String>();
    private final List<String> checkBoxesCategories = new ArrayList<String>();
    private final List<String> defaultOffRules = new ArrayList<String>();
    private Set<String> inactiveRuleIds = new HashSet<String>();
    private Set<String> enabledRuleIds = new HashSet<String>();
    private Set<String> inactiveCategoryNames = new HashSet<String>();
    private final List<JCheckBox> categoryCheckBoxes = new ArrayList<JCheckBox>();
    private final List<String> checkBoxesCategoryNames = new ArrayList<String>();
    private Language motherTongue;
    private boolean serverMode;
    private int serverPort;
    private boolean useGUIConfig;
    private final Frame owner;
    private final boolean insideOOo;
    private JCheckBox serverSettingsCheckbox;

    public ConfigurationDialog(Frame owner, boolean insideOOo) {
        this.owner = owner;
        this.insideOOo = insideOOo;
        this.messages = JLanguageTool.getMessageBundle();
    }

    public void show(List<Rule> rules) {
        this.dialog = new JDialog(this.owner, true);
        this.dialog.setTitle(this.messages.getString("guiConfigWindowTitle"));
        this.checkBoxes.clear();
        this.checkBoxesRuleIds.clear();
        this.categoryCheckBoxes.clear();
        this.checkBoxesCategoryNames.clear();
        Collections.sort(rules, new CategoryComparator());
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationDialog.this.dialog.setVisible(false);
            }
        };
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 18;
        cons.gridx = 0;
        int row = 0;
        String prevID = null;
        String prevCategory = null;
        for (Rule rule : rules) {
            if (prevID == null || !rule.getId().equals(prevID)) {
                boolean showHeadline;
                cons.gridy = row;
                JCheckBox checkBox = new JCheckBox(rule.getDescription());
                if (this.inactiveRuleIds != null && (this.inactiveRuleIds.contains(rule.getId()) || this.inactiveCategoryNames.contains(rule.getCategory().getName()))) {
                    checkBox.setSelected(false);
                } else {
                    checkBox.setSelected(true);
                }
                if (rule.isDefaultOff()) {
                    if (this.enabledRuleIds.contains(rule.getId())) {
                        checkBox.setSelected(true);
                    } else {
                        checkBox.setSelected(false);
                    }
                }
                if (rule.isDefaultOff()) {
                    this.defaultOffRules.add(rule.getId());
                    if (rule.getCategory().isDefaultOff()) {
                        this.inactiveCategoryNames.add(rule.getCategory().getName());
                    }
                } else if (rule.getCategory().isDefaultOff()) {
                    this.inactiveCategoryNames.remove(rule.getCategory().getName());
                }
                ActionListener ruleCheckBoxListener = this.makeRuleCheckboxListener();
                checkBox.addActionListener(ruleCheckBoxListener);
                this.checkBoxes.add(checkBox);
                this.checkBoxesRuleIds.add(rule.getId());
                this.checkBoxesCategories.add(rule.getCategory().getName());
                boolean bl = showHeadline = rule.getCategory() != null && !rule.getCategory().getName().equals(prevCategory);
                if ((showHeadline || prevCategory == null) && rule.getCategory() != null) {
                    JCheckBox categoryCheckBox = new JCheckBox(rule.getCategory().getName());
                    if (this.inactiveCategoryNames != null && this.inactiveCategoryNames.contains(rule.getCategory().getName())) {
                        categoryCheckBox.setSelected(false);
                    } else {
                        categoryCheckBox.setSelected(true);
                    }
                    ActionListener categoryCheckBoxListener = this.makeCategoryCheckboxListener();
                    categoryCheckBox.addActionListener(categoryCheckBoxListener);
                    this.categoryCheckBoxes.add(categoryCheckBox);
                    this.checkBoxesCategoryNames.add(rule.getCategory().getName());
                    checkBoxPanel.add((Component)categoryCheckBox, cons);
                    prevCategory = rule.getCategory().getName();
                    ++cons.gridy;
                    ++row;
                }
                checkBox.setMargin(new Insets(0, 20, 0, 0));
                checkBoxPanel.add((Component)checkBox, cons);
                ++row;
            }
            prevID = rule.getId();
        }
        JPanel motherTonguePanel = new JPanel();
        motherTonguePanel.add((Component)new JLabel(this.messages.getString("guiMotherTongue")), cons);
        this.motherTongueBox = new JComboBox<Object>(this.getPossibleMotherTongues());
        if (this.motherTongue != null) {
            if (this.motherTongue == Language.DEMO) {
                this.motherTongueBox.setSelectedItem(NO_MOTHER_TONGUE);
            } else {
                this.motherTongueBox.setSelectedItem(this.motherTongue.getTranslatedName(this.messages));
            }
        }
        motherTonguePanel.add((Component)this.motherTongueBox, cons);
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.weightx = 0.0;
        if (!this.insideOOo) {
            this.serverCheckbox = new JCheckBox(StringTools.getLabel((String)this.messages.getString("guiRunOnPort")));
            this.serverCheckbox.setMnemonic(StringTools.getMnemonic((String)this.messages.getString("guiRunOnPort")));
            this.serverCheckbox.setSelected(this.serverMode);
            portPanel.add((Component)this.serverCheckbox, cons);
            this.serverPortField = new JTextField(Integer.toString(this.serverPort));
            this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
            this.serverSettingsCheckbox = new JCheckBox(StringTools.getLabel((String)this.messages.getString("useGUIConfig")));
            this.serverPortField.setMinimumSize(new Dimension(100, 25));
            cons.gridx = 1;
            this.serverCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigurationDialog.this.serverPortField.setEnabled(ConfigurationDialog.this.serverCheckbox.isSelected());
                    ConfigurationDialog.this.serverSettingsCheckbox.setEnabled(ConfigurationDialog.this.serverCheckbox.isSelected());
                }
            });
            portPanel.add((Component)this.serverPortField, cons);
            cons.gridx = 0;
            cons.gridy = 10;
            this.serverSettingsCheckbox.setMnemonic(StringTools.getMnemonic((String)this.messages.getString("useGUIConfig")));
            this.serverSettingsCheckbox.setSelected(this.useGUIConfig);
            this.serverSettingsCheckbox.setEnabled(this.serverMode);
            portPanel.add((Component)this.serverSettingsCheckbox, cons);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton(StringTools.getLabel((String)this.messages.getString("guiOKButton")));
        this.okButton.setMnemonic(StringTools.getMnemonic((String)this.messages.getString("guiOKButton")));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(StringTools.getLabel((String)this.messages.getString("guiCancelButton")));
        this.cancelButton.setMnemonic(StringTools.getMnemonic((String)this.messages.getString("guiCancelButton")));
        this.cancelButton.addActionListener(this);
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        buttonPanel.add((Component)this.okButton, cons);
        buttonPanel.add((Component)this.cancelButton, cons);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        contentPane.add((Component)new JScrollPane(checkBoxPanel), cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        contentPane.add((Component)motherTonguePanel, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 17;
        contentPane.add((Component)portPanel, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 13;
        contentPane.add((Component)buttonPanel, cons);
        this.dialog.pack();
        this.dialog.setSize(500, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        this.dialog.setVisible(true);
    }

    private ActionListener makeRuleCheckboxListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox cBox = (JCheckBox)actionEvent.getSource();
                boolean selected = cBox.getModel().isSelected();
                int i = 0;
                for (JCheckBox chBox : ConfigurationDialog.this.checkBoxes) {
                    if (chBox.equals(cBox)) {
                        int catNo = ConfigurationDialog.this.checkBoxesCategoryNames.indexOf(ConfigurationDialog.this.checkBoxesCategories.get(i));
                        if (selected && !((JCheckBox)ConfigurationDialog.this.categoryCheckBoxes.get(catNo)).isSelected()) {
                            ((JCheckBox)ConfigurationDialog.this.categoryCheckBoxes.get(catNo)).setSelected(true);
                        }
                    }
                    ++i;
                }
            }
        };
    }

    private ActionListener makeCategoryCheckboxListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox cBox = (JCheckBox)actionEvent.getSource();
                boolean selected = cBox.getModel().isSelected();
                int i = 0;
                for (JCheckBox ruleBox : ConfigurationDialog.this.checkBoxes) {
                    if (ruleBox.isSelected() != selected && ((String)ConfigurationDialog.this.checkBoxesCategories.get(i)).equals(cBox.getText())) {
                        ruleBox.setSelected(selected);
                    }
                    ++i;
                }
            }
        };
    }

    private Object[] getPossibleMotherTongues() {
        ArrayList<String> motherTongues = new ArrayList<String>();
        motherTongues.add(NO_MOTHER_TONGUE);
        for (Language lang : Language.LANGUAGES) {
            if (lang == Language.DEMO) continue;
            motherTongues.add(lang.getTranslatedName(this.messages));
        }
        return motherTongues.toArray();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int i = 0;
            this.inactiveCategoryNames.clear();
            for (JCheckBox checkBox : this.categoryCheckBoxes) {
                if (!checkBox.isSelected()) {
                    String categoryName = this.checkBoxesCategoryNames.get(i);
                    this.inactiveCategoryNames.add(categoryName);
                }
                ++i;
            }
            i = 0;
            this.inactiveRuleIds.clear();
            this.enabledRuleIds.clear();
            for (JCheckBox checkBox : this.checkBoxes) {
                String ruleId;
                if (!checkBox.isSelected() && !this.defaultOffRules.contains(ruleId = this.checkBoxesRuleIds.get(i))) {
                    this.inactiveRuleIds.add(ruleId);
                }
                if (checkBox.isSelected() && this.defaultOffRules.contains(ruleId = this.checkBoxesRuleIds.get(i))) {
                    this.enabledRuleIds.add(ruleId);
                }
                ++i;
            }
            this.motherTongue = this.motherTongueBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(this.motherTongueBox.getSelectedItem().toString()) : (Language)this.motherTongueBox.getSelectedItem();
            if (this.serverCheckbox != null) {
                this.serverMode = this.serverCheckbox.isSelected();
                this.serverPort = Integer.parseInt(this.serverPortField.getText());
            }
            if (this.serverSettingsCheckbox != null) {
                this.useGUIConfig = this.serverSettingsCheckbox.isSelected();
            }
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.dialog.setVisible(false);
        }
    }

    public void setDisabledRules(Set<String> ruleIDs) {
        this.inactiveRuleIds = ruleIDs;
    }

    public Set<String> getDisabledRuleIds() {
        return this.inactiveRuleIds;
    }

    public void setEnabledRules(Set<String> ruleIDs) {
        this.enabledRuleIds = ruleIDs;
    }

    public Set<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public void setDisabledCategories(Set<String> categoryNames) {
        this.inactiveCategoryNames = categoryNames;
    }

    public Set<String> getDisabledCategoryNames() {
        return this.inactiveCategoryNames;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    public Language getMotherTongue() {
        return this.motherTongue;
    }

    private Language getLanguageForLocalizedName(String languageName) {
        for (Language element : Language.LANGUAGES) {
            if (NO_MOTHER_TONGUE.equals(languageName)) {
                return Language.DEMO;
            }
            if (!languageName.equals(element.getTranslatedName(this.messages))) continue;
            return element;
        }
        return null;
    }

    public void setRunServer(boolean serverMode) {
        this.serverMode = serverMode;
    }

    public void setUseGUIConfig(boolean useGUIConfig) {
        this.useGUIConfig = useGUIConfig;
    }

    public boolean getUseGUIConfig() {
        if (this.serverSettingsCheckbox == null) {
            return false;
        }
        return this.serverSettingsCheckbox.isSelected();
    }

    public boolean getRunServer() {
        if (this.serverCheckbox == null) {
            return false;
        }
        return this.serverCheckbox.isSelected();
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        if (this.serverPortField == null) {
            return 8081;
        }
        return Integer.parseInt(this.serverPortField.getText());
    }
}

