/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.languagetool.Language;
import org.languagetool.tools.StringTools;

public class Configuration {
    static final int DEFAULT_SERVER_PORT = 8081;
    private static final String CONFIG_FILE = "languagetool.properties";
    private static final String DISABLED_RULES_CONFIG_KEY = "disabledRules";
    private static final String ENABLED_RULES_CONFIG_KEY = "enabledRules";
    private static final String DISABLED_CATEGORIES_CONFIG_KEY = "disabledCategories";
    private static final String MOTHER_TONGUE_CONFIG_KEY = "motherTongue";
    private static final String AUTO_DETECT_CONFIG_KEY = "autoDetect";
    private static final String SERVER_RUN_CONFIG_KEY = "serverMode";
    private static final String SERVER_PORT_CONFIG_KEY = "serverPort";
    private static final String USE_GUI_CONFIG_KEY = "useGUIConfig";
    private static final String DELIMITER = ",";
    private final File configFile;
    private final HashMap<String, String> configForOtherLangs;
    private Set<String> disabledRuleIds = new HashSet<String>();
    private Set<String> enabledRuleIds = new HashSet<String>();
    private Set<String> disabledCategoryNames = new HashSet<String>();
    private Language motherTongue;
    private boolean runServer;
    private boolean autoDetect;
    private boolean guiConfig;
    private int serverPort = 8081;

    public Configuration(Language lang) throws IOException {
        this(new File(System.getProperty("user.home")), CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, String filename, Language lang) throws IOException {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + baseDir);
        }
        this.configFile = new File(baseDir, filename);
        this.configForOtherLangs = new HashMap();
        this.loadConfiguration(lang);
    }

    public Configuration(File baseDir, Language lang) throws IOException {
        this(baseDir, CONFIG_FILE, lang);
    }

    public Set<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public Set<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public Set<String> getDisabledCategoryNames() {
        return this.disabledCategoryNames;
    }

    public void setDisabledRuleIds(Set<String> ruleIDs) {
        this.disabledRuleIds = ruleIDs;
    }

    public void setEnabledRuleIds(Set<String> ruleIDs) {
        this.enabledRuleIds = ruleIDs;
    }

    public void setDisabledCategoryNames(Set<String> categoryNames) {
        this.disabledCategoryNames = categoryNames;
    }

    public Language getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    public boolean getAutoDetect() {
        return this.autoDetect;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    public boolean getRunServer() {
        return this.runServer;
    }

    public void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setUseGUIConfig(boolean useGUIConfig) {
        this.guiConfig = useGUIConfig;
    }

    public boolean getUseGUIConfig() {
        return this.guiConfig;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(Language lang) throws IOException {
        String qualifier = this.getQualifier(lang);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.configFile);
            Properties props = new Properties();
            props.load(fis);
            this.disabledRuleIds.addAll(this.getListFromProperties(props, DISABLED_RULES_CONFIG_KEY + qualifier));
            this.enabledRuleIds.addAll(this.getListFromProperties(props, ENABLED_RULES_CONFIG_KEY + qualifier));
            this.disabledCategoryNames.addAll(this.getListFromProperties(props, DISABLED_CATEGORIES_CONFIG_KEY + qualifier));
            String motherTongueStr = (String)props.get(MOTHER_TONGUE_CONFIG_KEY);
            if (motherTongueStr != null) {
                this.motherTongue = Language.getLanguageForShortName((String)motherTongueStr);
            }
            this.autoDetect = "true".equals(props.get(AUTO_DETECT_CONFIG_KEY));
            this.guiConfig = "true".equals(props.get(USE_GUI_CONFIG_KEY));
            this.runServer = "true".equals(props.get(SERVER_RUN_CONFIG_KEY));
            String serverPortString = (String)props.get(SERVER_PORT_CONFIG_KEY);
            if (serverPortString != null) {
                this.serverPort = Integer.parseInt(serverPortString);
            }
            this.loadConfigForOtherLanguages(lang, props);
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private String getQualifier(Language lang) {
        String qualifier = "";
        if (lang != null) {
            qualifier = "." + lang.getShortNameWithVariant();
        }
        return qualifier;
    }

    private void loadConfigForOtherLanguages(Language lang, Properties prop) {
        for (Language otherLang : Language.getAllLanguages()) {
            if (otherLang.equals(lang)) continue;
            String languageSuffix = "." + otherLang.getShortNameWithVariant();
            this.storeConfigKeyFromProp(prop, DISABLED_RULES_CONFIG_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, ENABLED_RULES_CONFIG_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, DISABLED_CATEGORIES_CONFIG_KEY + languageSuffix);
        }
    }

    private void storeConfigKeyFromProp(Properties prop, String key) {
        if (prop.containsKey(key)) {
            this.configForOtherLangs.put(key, prop.getProperty(key));
        }
    }

    private Collection<? extends String> getListFromProperties(Properties props, String key) {
        String value = (String)props.get(key);
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            String[] names = value.split(DELIMITER);
            list.addAll(Arrays.asList(names));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(Language lang) throws IOException {
        Properties props = new Properties();
        String qualifier = this.getQualifier(lang);
        this.addListToProperties(props, DISABLED_RULES_CONFIG_KEY + qualifier, this.disabledRuleIds);
        this.addListToProperties(props, ENABLED_RULES_CONFIG_KEY + qualifier, this.enabledRuleIds);
        this.addListToProperties(props, DISABLED_CATEGORIES_CONFIG_KEY + qualifier, this.disabledCategoryNames);
        if (this.motherTongue != null) {
            props.setProperty(MOTHER_TONGUE_CONFIG_KEY, this.motherTongue.getShortName());
        }
        props.setProperty(AUTO_DETECT_CONFIG_KEY, Boolean.valueOf(this.autoDetect).toString());
        props.setProperty(USE_GUI_CONFIG_KEY, Boolean.valueOf(this.guiConfig).toString());
        props.setProperty(SERVER_RUN_CONFIG_KEY, Boolean.valueOf(this.runServer).toString());
        props.setProperty(SERVER_PORT_CONFIG_KEY, Integer.valueOf(this.serverPort).toString());
        for (String key : this.configForOtherLangs.keySet()) {
            props.setProperty(key, this.configForOtherLangs.get(key));
        }
        FileOutputStream fos = new FileOutputStream(this.configFile);
        try {
            props.store(fos, "LanguageTool configuration");
        }
        finally {
            fos.close();
        }
    }

    private void addListToProperties(Properties props, String key, Set<String> list) {
        if (list == null) {
            props.setProperty(key, "");
        } else {
            props.setProperty(key, StringTools.listToString(list, (String)DELIMITER));
        }
    }
}

