/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.suggestions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.tuple.Pair;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesDataset;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesExperiment;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesTestConfig;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;

public class SuggestionChangesTest {
    public void testText() throws IOException {
        File configFile = new File(System.getProperty("config", "SuggestionChangesTestConfig.json"));
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        SuggestionChangesTestConfig config = (SuggestionChangesTestConfig)mapper.readValue(configFile, SuggestionChangesTestConfig.class);
        SuggestionsChanges.init((SuggestionChangesTestConfig)config, null);
        Path inputFile = Paths.get(System.getProperty("input"), new String[0]);
        String text = String.join((CharSequence)"\n", Files.readAllLines(inputFile));
        File ngrams = new File(SuggestionsChanges.getInstance().getConfig().ngramLocation);
        Language lang = Languages.getLanguageForShortCode((String)config.language);
        List experiments = SuggestionsChanges.getInstance().getExperiments();
        for (SuggestionChangesExperiment experiment : experiments) {
            SuggestionsChanges.getInstance().setCurrentExperiment(experiment);
            JLanguageTool lt = new JLanguageTool(lang);
            lt.activateLanguageModelRules(ngrams);
            List matches = lt.check(text);
            System.out.printf("%nExperiment %s running...%n", experiment);
            for (RuleMatch match : matches) {
                if (!match.getRule().isDictionaryBasedSpellingRule()) continue;
                String covered = text.substring(match.getFromPos(), match.getToPos());
                System.out.printf("Correction: '%s' -> %s%n", covered, match.getSuggestedReplacements());
            }
        }
    }

    public void testChanges() throws IOException, InterruptedException {
        File configFile = new File(System.getProperty("config", "SuggestionChangesTestConfig.json"));
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        SuggestionChangesTestConfig config = (SuggestionChangesTestConfig)mapper.readValue(configFile, SuggestionChangesTestConfig.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        Path loggingFile = Paths.get(config.logDir, String.format("suggestionChangesExperiment_%s.log", timestamp));
        Path datasetFile = Paths.get(config.logDir, String.format("suggestionChangesExperiment_%s.csv", timestamp));
        BufferedWriter writer = Files.newBufferedWriter(loggingFile, new OpenOption[0]);
        CSVPrinter datasetWriter = new CSVPrinter((Appendable)Files.newBufferedWriter(datasetFile, new OpenOption[0]), CSVFormat.DEFAULT.withEscape('\\'));
        ArrayList<String> datasetHeader = new ArrayList<String>(Arrays.asList("sentence", "correction", "covered", "replacement", "dataset_id"));
        SuggestionsChanges.init((SuggestionChangesTestConfig)config, (BufferedWriter)writer);
        writer.write("Evaluation configuration: \n");
        String configContent = String.join((CharSequence)"\n", Files.readAllLines(configFile.toPath()));
        writer.write(configContent);
        writer.write("\nRunning experiments: \n");
        int experimentId = 0;
        for (SuggestionChangesExperiment experiment : SuggestionsChanges.getInstance().getExperiments()) {
            writer.write(String.format("#%d: %s%n", ++experimentId, experiment));
            datasetHeader.add(String.format("experiment_%d_suggestions", experimentId));
            datasetHeader.add(String.format("experiment_%d_metadata", experimentId));
            datasetHeader.add(String.format("experiment_%d_suggestions_metadata", experimentId));
        }
        writer.newLine();
        datasetWriter.printRecord(datasetHeader);
        LinkedBlockingQueue<SuggestionTestData> tasks = new LinkedBlockingQueue<SuggestionTestData>(1000);
        ConcurrentLinkedQueue<Pair<SuggestionTestResultData, String>> results = new ConcurrentLinkedQueue<Pair<SuggestionTestResultData, String>>();
        ArrayList<SuggestionTestThread> threads = new ArrayList<SuggestionTestThread>();
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            SuggestionTestThread worker = new SuggestionTestThread(tasks, results);
            worker.start();
            threads.add(worker);
        }
        Thread logger = new Thread(() -> {
            try {
                long messages = 0L;
                while (true) {
                    Pair message;
                    if ((message = (Pair)results.poll()) == null) {
                        continue;
                    }
                    writer.write((String)message.getRight());
                    SuggestionTestResultData result = (SuggestionTestResultData)message.getLeft();
                    int datasetId = 1 + config.datasets.indexOf(result.getInput().getDataset());
                    if (result != null && result.getSuggestions() != null && !result.getSuggestions().isEmpty() && result.getSuggestions().stream().noneMatch(m -> m.getSuggestedReplacements() == null || m.getSuggestedReplacements().isEmpty())) {
                        ArrayList<Serializable> record = new ArrayList<Serializable>(Arrays.asList(result.getInput().getSentence(), result.getInput().getCorrection(), result.getInput().getCovered(), result.getInput().getReplacement(), datasetId));
                        for (RuleMatch match : result.getSuggestions()) {
                            List suggestions = match.getSuggestedReplacements();
                            record.add((Serializable)((Object)mapper.writeValueAsString((Object)suggestions)));
                            record.add((Serializable)((Object)mapper.writeValueAsString((Object)match.getFeatures())));
                            ArrayList<SortedMap> suggestionsMetadata = new ArrayList<SortedMap>();
                            for (SuggestedReplacement replacement : match.getSuggestedReplacementObjects()) {
                                suggestionsMetadata.add(replacement.getFeatures());
                            }
                            record.add((Serializable)((Object)mapper.writeValueAsString(suggestionsMetadata)));
                        }
                        datasetWriter.printRecord(record);
                    }
                    if (++messages % 1000L != 0L) continue;
                    writer.flush();
                    System.out.printf("Evaluated %d corrections.%n", messages);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        logger.setDaemon(true);
        logger.start();
        String[] header = new String[]{"id", "sentence", "correction", "language", "rule_id", "suggestion_pos", "accept_language", "country", "region", "created_at", "updated_at", "covered", "replacement", "text_session_id", "client"};
        int datasetId = 0;
        for (SuggestionChangesDataset suggestionChangesDataset : config.datasets) {
            writer.write(String.format("Evaluating dataset #%d: %s.%n", ++datasetId, suggestionChangesDataset));
            CSVFormat format = CSVFormat.DEFAULT;
            if (suggestionChangesDataset.type.equals("dump")) {
                format = format.withEscape('\\').withNullString("\\N").withHeader(header);
            } else if (suggestionChangesDataset.type.equals("artificial")) {
                format = format.withEscape('\\').withFirstRecordAsHeader();
            }
            try (CSVParser parser = new CSVParser((Reader)new FileReader(suggestionChangesDataset.path), format);){
                for (CSVRecord record : parser) {
                    String userLanguage;
                    String[] entries;
                    String acceptLanguage;
                    String lang = record.get("language");
                    String rule = suggestionChangesDataset.type.equals("dump") ? record.get("rule_id") : "";
                    String covered = record.get("covered");
                    String replacement = record.get("replacement");
                    String sentence = record.get("sentence");
                    String correction = record.isSet("correction") ? record.get("correction") : "";
                    String string = acceptLanguage = suggestionChangesDataset.type.equals("dump") ? record.get("accept_language") : "";
                    if (sentence == null || sentence.trim().isEmpty() || !config.language.equals(lang) || suggestionChangesDataset.type.equals("dump") && !config.rule.equals(rule)) continue;
                    if (suggestionChangesDataset.enforceCorrect && !record.isSet("correction")) {
                        throw new IllegalStateException("enforceCorrect in dataset configuration enabled, but column 'correction' is not set for entry " + record);
                    }
                    if (suggestionChangesDataset.type.equals("dump") && suggestionChangesDataset.enforceAcceptLanguage && acceptLanguage != null && (entries = acceptLanguage.split(",", 2)).length == 2 && !config.language.equals(userLanguage = entries[0])) continue;
                    tasks.put(new SuggestionTestData(lang, sentence, covered, replacement, correction, suggestionChangesDataset));
                }
            }
        }
        for (Thread thread : threads) {
            thread.join();
        }
        logger.join(10000L);
        logger.interrupt();
        datasetWriter.close();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length != 2) {
            System.out.println("Usage: SuggestionChangesTest [mode] CONFIG_FILE");
            System.out.println("Mode is either 'text' or 'csv'");
            System.exit(1);
        }
        String mode = args[0];
        String config = args[1];
        System.setProperty("config", config);
        SuggestionChangesTest test = new SuggestionChangesTest();
        if ("text".equals(mode)) {
            test.testText();
        } else if ("csv".equals(mode)) {
            test.testChanges();
        } else {
            System.out.println("Usage: SuggestionChangesTest [mode] CONFIG_FILE");
            System.out.println("Mode is either 'text' or 'csv'");
            System.exit(1);
        }
    }

    static class SuggestionTestThread
    extends Thread {
        private final Random sampler = new Random(0L);
        private final ConcurrentLinkedQueue<Pair<SuggestionTestResultData, String>> results;
        private JLanguageTool standardLt;
        private Rule standardRule;
        private final Map<SuggestionChangesExperiment, Rule> rules = new HashMap<SuggestionChangesExperiment, Rule>();
        private final BlockingQueue<SuggestionTestData> tasks;

        SuggestionTestThread(BlockingQueue<SuggestionTestData> tasks, ConcurrentLinkedQueue<Pair<SuggestionTestResultData, String>> results) {
            this.tasks = tasks;
            this.results = results;
        }

        @Override
        public void run() {
            Language lang = Languages.getLanguageForShortCode((String)SuggestionsChanges.getInstance().getConfig().language);
            this.init(lang);
            while (!this.isInterrupted()) {
                try {
                    SuggestionTestData entry = this.tasks.poll(1L, TimeUnit.SECONDS);
                    if (entry == null) break;
                    this.doWork(entry);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(Language lang) {
            Iterator iterator = SuggestionsChanges.getInstance().getExperiments().iterator();
            BlockingQueue<SuggestionTestData> blockingQueue = this.tasks;
            synchronized (blockingQueue) {
                SuggestionsChanges.getInstance().setCurrentExperiment(null);
                this.standardLt = new JLanguageTool(lang);
                this.standardRule = this.standardLt.getAllRules().stream().filter(Rule::isDictionaryBasedSpellingRule).findFirst().orElse(null);
                while (iterator.hasNext()) {
                    SuggestionChangesExperiment experiment = (SuggestionChangesExperiment)iterator.next();
                    SuggestionsChanges.getInstance().setCurrentExperiment(experiment);
                    JLanguageTool lt = new JLanguageTool(lang);
                    try {
                        lt.activateLanguageModelRules(new File(SuggestionsChanges.getInstance().getConfig().ngramLocation));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Rule spellerRule = lt.getAllRules().stream().filter(Rule::isDictionaryBasedSpellingRule).findFirst().orElse(null);
                    this.rules.put(experiment, spellerRule);
                }
            }
        }

        void doWork(SuggestionTestData entry) throws IOException, InterruptedException {
            AnalyzedSentence correction;
            RuleMatch[] correctionMatches;
            AnalyzedSentence sentence = this.standardLt.getAnalyzedSentence(entry.getSentence());
            if (entry.getDataset().enforceCorrect && (correctionMatches = this.standardRule.match(correction = this.standardLt.getAnalyzedSentence(entry.getCorrection()))).length != 0) {
                String message = String.format("Error found in sentence '%s', ignoring because of 'enforceCorrect' flag.%n", entry.getCorrection());
                this.results.add((Pair<SuggestionTestResultData, String>)Pair.of((Object)new SuggestionTestResultData(entry, null), (Object)message));
                return;
            }
            if (this.sampler.nextFloat() > entry.getDataset().sampleRate) {
                return;
            }
            List experiments = SuggestionsChanges.getInstance().getExperiments();
            int experimentId = 0;
            StringBuilder message = new StringBuilder();
            message.append(String.format("Checking candidates for correction '%s' -> '%s' in sentence '%s':%n", entry.getCovered(), entry.getReplacement(), entry.getSentence()));
            ArrayList<String> correct = new ArrayList<String>();
            ArrayList<RuleMatch> gatheredSuggestions = new ArrayList<RuleMatch>(experiments.size());
            int textSize = sentence.getText().length();
            for (SuggestionChangesExperiment experiment : experiments) {
                ++experimentId;
                Rule spellerRule = this.rules.get(experiment);
                if (spellerRule == null) continue;
                long startTime = System.currentTimeMillis();
                RuleMatch[] matches = spellerRule.match(sentence);
                long computationTime = System.currentTimeMillis() - startTime;
                for (RuleMatch match : matches) {
                    String matchedWord = sentence.getText().substring(match.getFromPos(), match.getToPos());
                    if (!matchedWord.equals(entry.getCovered())) continue;
                    List suggestions = match.getSuggestedReplacements();
                    gatheredSuggestions.add(match);
                    if (suggestions.isEmpty()) continue;
                    int position = suggestions.indexOf(entry.getReplacement());
                    SuggestionsChanges.getInstance().trackExperimentResult(Pair.of((Object)experiment, (Object)entry.getDataset()), position, textSize, computationTime);
                    if (position == 0) {
                        correct.add(String.valueOf(experimentId));
                    }
                    message.append(String.format("Experiment #%d: %s -> accepted @ #%d%n", experimentId, suggestions, position));
                }
            }
            message.append(String.format("Correct suggestions by experiments: %s%n", String.join((CharSequence)", ", correct)));
            this.results.add((Pair<SuggestionTestResultData, String>)Pair.of((Object)new SuggestionTestResultData(entry, gatheredSuggestions), (Object)message.toString()));
        }
    }

    static class SuggestionTestData {
        private final String language;
        private final String sentence;
        private final String covered;
        private final String replacement;
        private final String correction;
        private final SuggestionChangesDataset dataset;

        public SuggestionTestData(String language, String sentence, String covered, String replacement, String correction, SuggestionChangesDataset dataset) {
            this.language = language;
            this.sentence = sentence;
            this.covered = covered;
            this.replacement = replacement;
            this.correction = correction;
            this.dataset = dataset;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSentence() {
            return this.sentence;
        }

        public String getCovered() {
            return this.covered;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public String getCorrection() {
            return this.correction;
        }

        public SuggestionChangesDataset getDataset() {
            return this.dataset;
        }
    }

    static class SuggestionTestResultData {
        private final SuggestionTestData input;
        private final List<RuleMatch> suggestions;

        SuggestionTestResultData(SuggestionTestData input, List<RuleMatch> suggestions) {
            this.input = input;
            this.suggestions = suggestions;
        }

        public SuggestionTestData getInput() {
            return this.input;
        }

        public List<RuleMatch> getSuggestions() {
            return this.suggestions;
        }
    }
}

