/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wordsimilarity;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.dev.wordsimilarity.GermanQwertzKeyboardDistance;
import org.languagetool.dev.wordsimilarity.KeyboardDistance;

class SimilarWordFinder {
    private static final int MAX_DIST = 1;
    private static final KeyboardDistance keyDistance = new GermanQwertzKeyboardDistance();
    private final KnownPairs knownPairs = new KnownPairs();

    SimilarWordFinder() {
    }

    private void createIndex(List<String> words, File indexDir) throws IOException {
        FSDirectory dir = FSDirectory.open((Path)indexDir.toPath());
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new StandardAnalyzer());
        System.out.println("Creating index...");
        int docs = 0;
        try (IndexWriter writer = new IndexWriter((Directory)dir, indexWriterConfig);){
            for (String word : words) {
                Document doc = new Document();
                doc.add((IndexableField)new TextField("word", word, Field.Store.YES));
                writer.addDocument((Iterable)doc);
                ++docs;
            }
        }
        System.out.println("Index created: " + docs + " docs");
    }

    private void findSimilarWords(File indexDir, List<String> words) throws IOException {
        FSDirectory dir = FSDirectory.open((Path)indexDir.toPath());
        try (DirectoryReader reader = DirectoryReader.open((Directory)dir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            for (String word : words) {
                this.findSimilarWordsTo(reader, searcher, word);
            }
        }
    }

    private void findSimilarWordsTo(DirectoryReader reader, IndexSearcher searcher, String word) throws IOException {
        FuzzyQuery query = new FuzzyQuery(new Term("word", word), 2);
        TopDocs topDocs = searcher.search((Query)query, 10);
        List<SimWord> simWords = this.findSimilarWordsFor(reader, word, topDocs);
        for (SimWord simWord : simWords) {
            if (word.length() == simWord.word.length()) {
                int firstDiffPos = this.getDiffPos(simWord.word.toLowerCase(), word.toLowerCase());
                try {
                    float dist = keyDistance.getDistance(word.charAt(firstDiffPos), simWord.word.charAt(firstDiffPos));
                    System.out.println(dist + "; " + word + "; " + simWord);
                }
                catch (Exception e) {
                    System.err.println("Could not get distance between '" + word + "' and '" + simWord + "':");
                    e.printStackTrace();
                }
                continue;
            }
            if (this.case1(word, simWord.word) || this.case1(simWord.word, word)) {
                System.out.println("IGNORE: -; " + word + "; " + simWord.word);
                continue;
            }
            System.out.println("-; " + word + "; " + simWord.word);
        }
    }

    private boolean case1(String word1, String word2) {
        boolean ignore = word1.endsWith("s") && !word1.endsWith("es") && word2.endsWith("es");
        return ignore;
    }

    private void findSimilarWords(File indexDir) throws IOException {
        FSDirectory dir = FSDirectory.open((Path)indexDir.toPath());
        try (DirectoryReader reader = DirectoryReader.open((Directory)dir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            for (int i = 0; i < reader.maxDoc(); ++i) {
                Document doc = reader.document(i);
                String word = doc.get("word");
                this.findSimilarWordsTo(reader, searcher, word);
            }
        }
    }

    private List<SimWord> findSimilarWordsFor(DirectoryReader reader, String word, TopDocs topDocs) throws IOException {
        ArrayList<SimWord> result = new ArrayList<SimWord>();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            int dist;
            int limit;
            String simWord = reader.document(scoreDoc.doc).get("word");
            if (simWord.equalsIgnoreCase(word) || this.knownPairs.contains(simWord, word)) continue;
            int firstDiffPos = this.getDiffPos(simWord.toLowerCase(), word.toLowerCase());
            if (firstDiffPos <= (limit = Math.min(word.length(), simWord.length()) - 1) && (dist = StringUtils.getLevenshteinDistance((CharSequence)word, (CharSequence)simWord)) <= 1) {
                result.add(new SimWord(simWord, dist));
            }
            this.knownPairs.add(simWord, word);
        }
        return result;
    }

    private int getDiffPos(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length(); ++i) {
            if (i >= s2.length()) {
                return i;
            }
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return i;
    }

    public static void main(String[] args) throws IOException {
        SimilarWordFinder simWordFinder = new SimilarWordFinder();
        System.out.println("Using key distance: " + keyDistance.getClass());
        if (args.length == 1) {
            File indexDir = new File(args[0]);
            simWordFinder.findSimilarWords(indexDir);
        } else if (args.length == 2) {
            File indexDir = new File(args[1]);
            String[] words = args[0].split(",");
            simWordFinder.findSimilarWords(indexDir, Arrays.asList(words));
        } else if (args.length == 3) {
            List words = FileUtils.readLines((File)new File(args[1]), (String)"utf-8");
            File indexDir = new File(args[2]);
            Files.deleteIfExists(indexDir.toPath());
            simWordFinder.createIndex(words, indexDir);
        } else {
            System.out.println("Usage 1: " + SimilarWordFinder.class.getSimpleName() + " --index <wordFile> <indexDir>");
            System.out.println("Usage 2: " + SimilarWordFinder.class.getSimpleName() + " <words> <indexDir> (as created with usage 1)");
            System.out.println("             <indexDir> as created with usage 1");
            System.out.println("             <words> a comma-separated list of words to search similar words for (no spaces)");
            System.out.println("Usage 3: " + SimilarWordFinder.class.getSimpleName() + " <indexDir>");
            System.exit(1);
        }
    }

    static class KnownPairs {
        private final Set<String> set = new HashSet<String>();

        KnownPairs() {
        }

        boolean contains(String word1, String word2) {
            return this.set.contains(this.getKey(word1, word2));
        }

        void add(String word1, String word2) {
            this.set.add(this.getKey(word1, word2));
        }

        String getKey(String word1, String word2) {
            if (word1.compareTo(word2) < 0) {
                return word1 + ";" + word2;
            }
            return word2 + ";" + word1;
        }
    }

    static class SimWord {
        private final String word;
        private final int levenshteinDistance;

        SimWord(String word, int levenshteinDistance) {
            this.word = word;
            this.levenshteinDistance = levenshteinDistance;
        }

        public String toString() {
            return this.word;
        }
    }
}

