/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.simulation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.dev.simulation.DocProvider;
import org.languagetool.tools.StringTools;

class TypingSimulator {
    private static final String apiUrl = "http://localhost:8081/v2/check";
    private static final boolean dryMode = false;
    private static final int warmUpChecks = 20;
    private static final float copyPasteProb = 0.05f;
    private static final float backSpaceProb = 0.05f;
    private static final float typoProb = 0.03f;
    private static final int minWaitMillis = 0;
    private static final int avgWaitMillis = 0;
    private static final int checkAtMostEveryMillis = 10;

    TypingSimulator() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + TypingSimulator.class.getSimpleName() + " <input> <docsPerRun>");
            System.exit(1);
        }
        DocProvider docProvider = new DocProvider(Files.readAllLines(Paths.get(args[0], new String[0])));
        int docsPerRun = Integer.parseInt(args[1]);
        if (docsPerRun < 1000) {
            System.out.println("*** WARNING: use >= 1000 for docsPerRun or results will not be realistic (watch the size distribution printed at the end)");
        }
        long startTime = System.currentTimeMillis();
        new TypingSimulator().run(docProvider, docsPerRun);
        long endTime = System.currentTimeMillis();
        System.out.println("Total time for " + TypingSimulator.class.getSimpleName() + ": " + (endTime - startTime) + "ms");
    }

    private void run(DocProvider docs, int docsPerRun) {
        System.out.println("Using API at http://localhost:8081/v2/check");
        ArrayList<Long> totalTimes = new ArrayList<Long>();
        ArrayList<Float> avgTimes = new ArrayList<Float>();
        int maxRuns = 3;
        Random rnd = new Random(123L);
        System.out.printf("Using %d docs per run\n", docsPerRun);
        for (int i = 0; i < maxRuns; ++i) {
            System.out.println("=== Run " + (i + 1) + " of " + maxRuns + " =====================");
            Stats stats = new Stats();
            for (int j = 0; j < docsPerRun; ++j) {
                System.out.printf("Run %d, doc %d/%d...\n", i + 1, j, docsPerRun);
                this.runOnDoc(docs.getDoc(), rnd, stats);
            }
            totalTimes.add(stats.totalTime);
            float avg = (float)stats.totalTime / (float)stats.totalChecks;
            avgTimes.add(Float.valueOf(avg));
            stats.printRequestSizeSummary();
            docs.reset();
        }
        totalTimes.sort(Long::compareTo);
        avgTimes.sort(Float::compareTo);
        System.out.println("Total times: " + totalTimes + " ms");
        System.out.printf(Locale.ENGLISH, "Avg. times per doc: %s ms\n", avgTimes);
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
        String totalTimesStr = totalTimes.stream().map(k -> k.toString()).collect(Collectors.joining(";"));
        String avgTimesStr = avgTimes.stream().map(k -> k.toString()).collect(Collectors.joining(";"));
        System.out.printf(Locale.ENGLISH, "CSV: %s,%s,%s\n", date, totalTimesStr, avgTimesStr);
    }

    private void runOnDoc(String doc, Random rnd, Stats stats) {
        if (rnd.nextFloat() < 0.05f) {
            this.check(doc, stats, true);
        } else {
            long lastCheck = 0L;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < doc.length(); ++i) {
                if (rnd.nextFloat() < 0.03f) {
                    if (rnd.nextBoolean()) {
                        sb.append("x");
                    } else if (sb.length() > 0) {
                        sb.replace(sb.length() - 1, sb.length(), "");
                    }
                }
                if (rnd.nextFloat() < 0.05f && i > 2) {
                    sb.replace(sb.length() - 1, sb.length(), "");
                    this.check(sb.toString(), stats, false);
                    i -= 2;
                } else {
                    char c = doc.charAt(i);
                    sb.append(c);
                }
                long millisSinceLastCheck = System.currentTimeMillis() - lastCheck;
                if (millisSinceLastCheck > 10L || i == doc.length() - 1) {
                    this.check(sb.toString(), stats, false);
                    lastCheck = System.currentTimeMillis();
                }
                this.sleep(rnd);
            }
        }
    }

    private void sleep(Random rnd) {
    }

    private void check(String doc, Stats stats, boolean checkCompleteText) {
        try {
            if (checkCompleteText) {
                this.checkByPOST(doc, "allButTextLevelOnly", stats);
            } else {
                String[] paras = doc.split("\n\n");
                String lastPara = paras[paras.length - 1];
                this.checkByPOST(lastPara, "allButTextLevelOnly", stats);
            }
            this.checkByPOST(doc, "textLevelOnly", stats);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkByPOST(String text, String mode, Stats stats) throws IOException {
        long runTimeStart = System.currentTimeMillis();
        String postData = "&mode=" + mode + "&text=" + URLEncoder.encode(text, "UTF-8") + "&textSessionId=10914:1608926270970&enableHiddenRules=true&motherTongue=de&language=auto&noopLanguages=de,en&preferredLanguages=de,en&preferredVariants=en-US,de-DE,pt-BR,ca-ES&disabledRules=WHITESPACE_RULE&useragent=performance-test";
        URL url = new URL("http://localhost:8081/v2/check?instanceId=10914%3A1608926270970&c=1&v=0.0.0");
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            this.checkAtUrlByPost(url, postData, map);
            long runTime = System.currentTimeMillis() - runTimeStart;
            System.out.printf("%sms %s chars %s: %s %s\n", String.format("%1$5d", runTime), String.format("%1$5d", text.length()), String.format("%1$10s", mode.replaceAll("[Tt]extLevelOnly", "TLO")), StringUtils.abbreviate((String)text.replace("\n", "\\n"), (int)100), "");
            if (stats.totalChecksSkipped < 20L) {
                System.out.println("Warm-up, ignoring result...");
                ++stats.totalChecksSkipped;
            } else {
                ++stats.totalChecks;
                stats.totalTime += runTime;
                stats.trackRequestBySize(text.length());
            }
        }
        catch (IOException e) {
            System.err.println("Got error from " + url + " (" + text.length() + " chars): " + e.getMessage() + ", text was (" + text.length() + " chars): '" + StringUtils.abbreviate((String)text, (int)100) + "'");
            e.printStackTrace();
        }
    }

    private String checkAtUrlByPost(URL url, String postData, Map<String, String> properties) throws IOException {
        String keepAlive = System.getProperty("http.keepAlive");
        try {
            String string;
            System.setProperty("http.keepAlive", "false");
            URLConnection connection = url.openConnection();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(postData);
                ((Writer)writer).flush();
                string = StringTools.streamToString((InputStream)connection.getInputStream(), (String)"UTF-8");
            }
            return string;
        }
        finally {
            if (keepAlive != null) {
                System.setProperty("http.keepAlive", keepAlive);
            }
        }
    }

    static class Stats {
        private static final int stepSize = 50;
        private long totalTime = 0L;
        private long totalChecks = 0L;
        private long totalChecksSkipped = 0L;
        private final Map<Integer, Integer> sizeToChecks = new TreeMap<Integer, Integer>();
        private int sizeToChecksLarger = 0;

        Stats() {
            for (int i = 0; i <= 500; i += 50) {
                this.sizeToChecks.put(i, 0);
            }
        }

        void trackRequestBySize(int size) {
            if (size >= 550) {
                ++this.sizeToChecksLarger;
            } else {
                int key = size - size % 50;
                this.sizeToChecks.put(key, this.sizeToChecks.get(key) + 1);
            }
        }

        void printRequestSizeSummary() {
            System.out.println("Summary of request sizes sent ('0' means 0 to 49 chars):");
            for (int i = 0; i <= 500; i += 50) {
                Integer checks = this.sizeToChecks.get(i);
                float percent = (float)checks.intValue() / (float)this.totalChecks * 100.0f;
                System.out.printf(Locale.ENGLISH, "%s  -> %d (%.0f%%)\n", StringUtils.leftPad((String)String.valueOf(i), (int)3), checks, Float.valueOf(percent));
            }
            float percent = (float)this.sizeToChecksLarger / (float)this.totalChecks * 100.0f;
            System.out.printf(Locale.ENGLISH, "%s  -> %d (%.0f%%)\n", StringUtils.leftPad((String)"550+", (int)3), this.sizeToChecksLarger, Float.valueOf(percent));
        }
    }
}

