/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.messagechecker;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.StringTools;

public class LTMessageChecker {
    private static final boolean SPELLCHECK_ONLY = false;
    private static final List<String> ruleExceptions = Arrays.asList("DE_CASE", "UPPERCASE_SENTENCE_START");

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: " + LTMessageChecker.class.getSimpleName() + " <langCode> | ALL");
            System.exit(1);
        }
        LTMessageChecker check = new LTMessageChecker();
        long start = System.currentTimeMillis();
        if (args[0].equalsIgnoreCase("all")) {
            for (Language lang : Languages.get()) {
                check.run(lang);
            }
        } else {
            check.run(Languages.getLanguageForShortCode((String)args[0]));
        }
        float time = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        LTMessageChecker.print("Total checking time: " + String.format("%.2f", Float.valueOf(time)) + " seconds");
    }

    private static void print(String s) {
        System.out.println("LTM: " + s);
    }

    private void run(Language lang) throws IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long start = System.currentTimeMillis();
        JLanguageTool lt = new JLanguageTool(lang);
        ContextTools contextTools = new ContextTools();
        contextTools.setErrorMarker("**", "**");
        contextTools.setEscapeHtml(false);
        LTMessageChecker.print("Checking language: " + lang.getName() + " (" + lang.getShortCodeWithCountryAndVariant() + ")");
        LTMessageChecker.print("Version: " + JLanguageTool.VERSION + " (" + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID + ")");
        for (Rule r : lt.getAllRules()) {
            String message = "";
            try {
                Method m = r.getClass().getMethod("getMessage", null);
                message = (String)m.invoke((Object)r, new Object[0]);
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            String shortMessage = "";
            try {
                Method m = r.getClass().getMethod("getShortMessage", null);
                shortMessage = (String)m.invoke((Object)r, new Object[0]);
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            if (!message.isEmpty()) {
                message = lang.toAdvancedTypography(message);
                message = message.replace("<suggestion>", lang.getOpeningDoubleQuote()).replace("</suggestion>", lang.getClosingDoubleQuote());
                message = message.replaceAll("<[^>]+>", "");
            }
            Object corrections = "";
            for (IncorrectExample ie : r.getIncorrectExamples()) {
                corrections = (String)corrections + String.join((CharSequence)"; ", ie.getCorrections()) + "; ";
            }
            String ruleDescription = lang.toAdvancedTypography(StringTools.uppercaseFirstChar((String)r.getDescription()));
            String textToCheck = message + "\n\n" + shortMessage + "\n\n" + ruleDescription;
            this.checkText(textToCheck, lt, lang, r, contextTools, false);
            this.checkText((String)corrections, lt, lang, r, contextTools, true);
        }
        float time = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        LTMessageChecker.print("Checked " + lang.getName() + " (" + lang.getShortCodeWithCountryAndVariant() + ") in " + String.format("%.2f", Float.valueOf(time)) + " seconds");
    }

    void checkText(String textToCheck, JLanguageTool lt, Language lang, Rule r, ContextTools contextTools, boolean isCorrection) throws IOException {
        List matches;
        if (!textToCheck.isEmpty() && (matches = lt.check(textToCheck)).size() > 0) {
            ArrayList<RuleMatch> matchesToShow = new ArrayList<RuleMatch>();
            for (RuleMatch match : matches) {
                String ruleId = match.getRule().getId();
                if (isCorrection && ruleExceptions.contains(ruleId) || ruleId.equals(r.getId())) continue;
                matchesToShow.add(match);
            }
            if (matchesToShow.size() > 0) {
                LTMessageChecker.print("Source: " + r.getFullId());
                for (RuleMatch match : matchesToShow) {
                    LTMessageChecker.print(lang.toAdvancedTypography(match.getMessage()));
                    LTMessageChecker.print(contextTools.getContext(match.getFromPos(), match.getToPos(), textToCheck));
                    LTMessageChecker.print("");
                }
            }
        }
    }
}

