/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.httpchecker;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.dev.httpchecker.CheckCallable;

class HttpApiSentenceChecker {
    private final String baseUrl;
    private final String langCode;
    private final int threadCount;
    private final String token;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    @Nullable
    private final String parameters;

    public HttpApiSentenceChecker(CommandLine cmd) {
        String string = this.baseUrl = cmd.hasOption("url") ? cmd.getOptionValue("url") : "https://api.languagetool.org";
        if (this.baseUrl.endsWith("/")) {
            throw new IllegalArgumentException("Don't let baseUrl end with a '/': " + this.baseUrl + ". Correct example: 'https://api.languagetool.org'");
        }
        this.langCode = cmd.getOptionValue("lang");
        this.threadCount = Integer.parseInt(cmd.getOptionValue("threads"));
        this.token = cmd.hasOption("token") ? cmd.getOptionValue("token") : null;
        this.user = cmd.hasOption("user") ? cmd.getOptionValue("user") : null;
        this.password = cmd.hasOption("password") ? cmd.getOptionValue("password") : null;
        this.parameters = cmd.hasOption("parameters") ? cmd.getOptionValue("parameters") : null;
    }

    private void run(File input, File output) throws IOException, InterruptedException, ExecutionException {
        long t1 = System.currentTimeMillis();
        int lines = this.countLines(input);
        System.out.println(input + " has " + lines + " lines");
        List<String> inputTexts = this.splitInput(input, this.threadCount);
        List<File> threadFiles = this.runOnTexts(inputTexts);
        this.joinResults(threadFiles, output);
        long t2 = System.currentTimeMillis();
        Duration duration = Duration.of(t2 - t1, ChronoUnit.MILLIS);
        System.out.println("Runtime: " + this.formatDuration(duration) + " (h:mm:ss)");
    }

    private String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        return String.format("%d:%02d:%02d", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
    }

    private int countLines(File input) throws FileNotFoundException {
        int count = 0;
        try (Scanner sc = new Scanner(input);){
            while (sc.hasNextLine()) {
                sc.nextLine();
                ++count;
            }
        }
        return count;
    }

    private List<String> splitInput(File input, int threadCount) throws IOException {
        ArrayList<String> texts = new ArrayList<String>();
        int batchSize = 10;
        System.out.println("Working with " + threadCount + " threads, single batch size: 10 lines");
        int lineCount = 0;
        StringBuilder sb = new StringBuilder();
        try (Scanner sc = new Scanner(input);){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                sb.append(line);
                sb.append("\n");
                if (++lineCount <= 0 || lineCount % 10 != 0) continue;
                texts.add(sb.toString());
                sb = new StringBuilder();
            }
        }
        System.out.println(lineCount + " lines from " + input + " split into " + texts.size() + " text of 10 lines each");
        return texts;
    }

    private List<File> runOnTexts(List<String> texts) throws InterruptedException, ExecutionException {
        ArrayList<File> resultFiles = new ArrayList<File>();
        ForkJoinPool execService = new ForkJoinPool(this.threadCount, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, false);
        ArrayList<CheckCallable> callables = new ArrayList<CheckCallable>();
        int count = 0;
        int textsPerThread = texts.size() / this.threadCount;
        System.out.println("textsPerThread: " + textsPerThread);
        Collections.shuffle(texts, new Random(123L));
        for (int i = 0; i < this.threadCount; ++i) {
            ArrayList<String> tmpTexts = new ArrayList<String>();
            for (int j = 0; j < textsPerThread; ++j) {
                if (texts.size() == 0) {
                    System.out.println("No more texts to be collected");
                    break;
                }
                tmpTexts.add(texts.remove(0));
            }
            callables.add(new CheckCallable(count, this.baseUrl, this.token, tmpTexts, this.langCode, this.user, this.password, this.parameters));
            System.out.println("Created thread " + count + " with " + tmpTexts.size() + " texts");
            ++count;
        }
        if (texts.size() > 0) {
            System.out.println(texts.size() + " texts remaining, creating another thread for them");
            callables.add(new CheckCallable(count, this.baseUrl, this.token, texts, this.langCode, this.user, this.password, this.parameters));
        } else {
            System.out.println("No texts remaining");
        }
        System.out.println("Created " + callables.size() + " threads");
        List futures = execService.invokeAll(callables);
        for (Future future : futures) {
            resultFiles.add((File)future.get());
        }
        execService.shutdownNow();
        return resultFiles;
    }

    private void joinResults(List<File> threadFiles, File output) throws IOException {
        System.out.println("Joining " + threadFiles.size() + " result files...");
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        threadFiles.sort(Comparator.naturalOrder());
        HashSet<String> buildDates = new HashSet<String>();
        try (FileWriter fw = new FileWriter(output);){
            for (File threadFile : threadFiles) {
                List<String> lines = Files.readAllLines(threadFile.toPath());
                for (String line : lines) {
                    JsonNode node;
                    try {
                        node = mapper.readTree(line);
                    }
                    catch (Exception e) {
                        System.err.println("ERROR: Could not parse line from " + threadFile + ": " + line);
                        throw e;
                    }
                    JsonNode date = node.get("software").get("buildDate");
                    if (date.isNull() && !line.contains("API request failed in a way so that re-try makes no sense: ")) {
                        System.err.println("WARNING: 'null' buildDate in " + threadFile + " with " + lines.size() + " lines, line: " + StringUtils.abbreviate((String)line, (int)500));
                    }
                    buildDates.add(date.asText());
                    fw.write(line);
                    fw.write(10);
                }
                FileUtils.deleteQuietly((File)threadFile);
            }
        }
        if (buildDates.size() > 1) {
            System.err.println("-----------------------------------------------------");
            System.err.println("WARNING: inconsistent build dates across API servers ('null' can be ignored): Found " + buildDates);
            System.err.println("-----------------------------------------------------");
        } else {
            System.out.println("All requests answered by API servers with build date " + buildDates);
        }
        System.out.println("Joined result stored at " + output);
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addRequiredOption(null, "input", true, "Plain text input file");
        options.addRequiredOption(null, "lang", true, "Language code, e.g. en-US");
        options.addRequiredOption(null, "threads", true, "Number of threads (NOTE: changing this will change output due to the way input is split)");
        options.addRequiredOption(null, "output", true, "Output file");
        options.addOption(null, "token", true, "Secret token to skip server's limits");
        options.addOption(null, "url", true, "Base URL, defaults to https://api.languagetool.org");
        options.addOption(null, "user", true, "User name for authentication (Basic Auth)");
        options.addOption(null, "password", true, "Password for authentication (Basic Auth)");
        options.addOption(null, "parameters", true, "Additional parameters to send with HTTP requests as form-encoded POST data");
        CommandLine cmd = new DefaultParser().parse(options, args);
        HttpApiSentenceChecker checker = new HttpApiSentenceChecker(cmd);
        checker.run(new File(cmd.getOptionValue("input")), new File(cmd.getOptionValue("output")));
    }
}

