/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.httpchecker;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.ToneTag;
import org.languagetool.dev.httpchecker.HttpApiSentenceChecker;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.RuleMatchesAsJsonSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

class CheckCallable
implements Callable<File> {
    static final String FAIL_MESSAGE = "API request failed in a way so that re-try makes no sense: ";
    private static final int maxTries = 10;
    private static final int retrySleepMillis = 1000;
    private final int count;
    private final String baseUrl;
    private final String token;
    private final List<String> texts;
    private final String langCode;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final String parameters;

    CheckCallable(int count, String baseUrl, String token, List<String> texts, String langCode, @Nullable String user, @Nullable String password, @Nullable String parameters) {
        this.count = count;
        this.baseUrl = Objects.requireNonNull(baseUrl);
        this.token = token;
        this.texts = Objects.requireNonNull(texts);
        this.langCode = Objects.requireNonNull(langCode);
        this.user = user;
        this.password = password;
        this.parameters = parameters;
    }

    @Override
    public File call() throws Exception {
        String threadName = Thread.currentThread().getName();
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        String baseUrlCode = String.valueOf(this.baseUrl.hashCode()).substring(0, 5);
        String filename = HttpApiSentenceChecker.class.getSimpleName() + "-result-" + this.langCode + "-" + baseUrlCode + "-" + this.count + ".json";
        File outFile = new File(System.getProperty("java.io.tmpdir"), filename);
        int totalLen = this.texts.stream().mapToInt(String::length).sum();
        this.printOut(threadName + " - Going to post " + this.texts.size() + " texts with a total length of " + totalLen + " chars");
        try (FileWriter fw = new FileWriter(outFile);){
            int i = 0;
            block8: for (String text : this.texts) {
                URL url = Tools.getUrl((String)(this.baseUrl + "/v2/check"));
                String postData = "language=" + this.langCode + "&text=" + URLEncoder.encode(text, "UTF-8");
                postData = postData + (String)(this.token != null ? "&token=" + URLEncoder.encode(this.token, "UTF-8") : "");
                postData = this.parameters != null ? postData + "&" + this.parameters : postData + "&toneTags=" + ToneTag.ALL_TONE_RULES.name() + "&level=picky&enableTempOffRules=true";
                String tokenInfo = this.token != null ? " with token" : " without token";
                float progress = (float)i++ / (float)this.texts.size() * 100.0f;
                this.printOut(String.format(Locale.ENGLISH, threadName + " - Posting text with " + text.length() + " chars to " + url + tokenInfo + ", %.1f%%", Float.valueOf(progress)));
                int retry = 1;
                while (true) {
                    String pseudoFileName = HttpApiSentenceChecker.class.getSimpleName() + "-result-" + text.hashCode();
                    try {
                        CheckResult result = this.checkByPost(url, postData);
                        JsonNode jsonNode = mapper.readTree(result.json);
                        ((ObjectNode)jsonNode).put("title", pseudoFileName);
                        fw.write(jsonNode + "\n");
                        continue block8;
                    }
                    catch (ApiErrorException e) {
                        this.printErr(threadName + " - POST to " + url + " failed with " + e.getClass().getName() + ": " + e.getMessage() + ", try " + retry + ", max tries 10, no retries useful for this type of error, storing error as pseudo match");
                        this.writeFakeError(mapper, fw, text, pseudoFileName, e, 0);
                        continue block8;
                    }
                    catch (Exception e) {
                        if (retry >= 10) {
                            this.printErr(threadName + " - POST to " + url + " failed with " + e.getClass().getName() + ": " + e.getMessage() + ", try " + retry + ", max tries 10, no retries left, writing fake error");
                            this.writeFakeError(mapper, fw, text, pseudoFileName, new ApiErrorException(e.getClass().getName() + ": " + e.getMessage()), retry);
                            continue block8;
                        }
                        long sleepMillis = 1000 * retry;
                        this.printErr(threadName + " - POST to " + url + " failed with " + e.getClass().getName() + ": " + e.getMessage() + ", try " + retry + ", max tries 10, sleeping " + sleepMillis + "ms before retry");
                        Thread.sleep(sleepMillis);
                        ++retry;
                        continue;
                    }
                    break;
                }
            }
        }
        this.printOut(threadName + " - Done.");
        this.printOut(threadName + " - Output written to " + outFile.getName());
        return outFile;
    }

    private void printOut(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(sdf.format(new Date()) + " " + s);
    }

    private void printErr(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.err.println(sdf.format(new Date()) + " " + s);
    }

    private synchronized void writeFakeError(ObjectMapper mapper, FileWriter fw, String textToCheck, String pseudoFileName, ApiErrorException e, int retries) throws IOException {
        Language lang = Languages.getLanguageForShortCode((String)this.langCode);
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)"en"));
        RuleMatch ruleMatch = new RuleMatch((Rule)new FakeRule(), lt.getAnalyzedSentence(textToCheck), 0, 1, FAIL_MESSAGE + e.getMessage() + " (retries: " + retries + ")");
        DetectedLanguage detectedLang = new DetectedLanguage(lang, lang);
        String json = new RuleMatchesAsJsonSerializer().ruleMatchesToJson(Collections.singletonList(ruleMatch), textToCheck, 100, detectedLang);
        JsonNode jsonNode = mapper.readTree(json);
        ((ObjectNode)jsonNode).put("title", pseudoFileName);
        fw.write(jsonNode + "\n");
    }

    private CheckResult checkByPost(URL url, String postData) throws IOException, ApiErrorException {
        String keepAlive = System.getProperty("http.keepAlive");
        try {
            CheckResult checkResult;
            System.setProperty("http.keepAlive", "false");
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            if (this.user != null && this.password != null) {
                String authString = this.user + ":" + this.password;
                String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
                conn.setRequestProperty("Authorization", "Basic " + encoded);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(postData);
                writer.flush();
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                if (httpConn.getResponseCode() >= 400) {
                    InputStream inputStream = httpConn.getErrorStream();
                    String error = StringTools.streamToString((InputStream)inputStream, (String)"UTF-8");
                    if (httpConn.getResponseCode() == 400) {
                        throw new ApiErrorException(error);
                    }
                    String backendServer = httpConn.getHeaderField("x-backend-server");
                    throw new IOException("Failed posting to " + url + ", server " + backendServer + " responded with code " + httpConn.getResponseCode() + " and error: " + error + " for postData: " + postData);
                }
                InputStream inputStream = httpConn.getInputStream();
                String json = StringTools.streamToString((InputStream)inputStream, (String)"UTF-8");
                String backendServer = conn.getHeaderField("x-backend-server");
                checkResult = new CheckResult(json, backendServer);
            }
            return checkResult;
        }
        finally {
            if (keepAlive != null) {
                System.setProperty("http.keepAlive", keepAlive);
            }
        }
    }

    static class CheckResult {
        String json;
        String backendServer;

        private CheckResult(String json, String backendServer) {
            this.json = json;
            this.backendServer = backendServer;
        }
    }

    static class ApiErrorException
    extends Exception {
        ApiErrorException(String message) {
            super(message);
        }
    }

    static class FakeRule
    extends Rule {
        FakeRule() {
        }

        public String getId() {
            return "FAKE_RULE";
        }

        public String getDescription() {
            return "Pseudo rule to contain API error";
        }

        public RuleMatch[] match(AnalyzedSentence sentence) {
            return RuleMatch.EMPTY_ARRAY;
        }
    }
}

