/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.dumpcheck.SentenceSourceChecker;

public class TatoebaEvaluator {
    private static final String template = "/home/dnaber/data/corpus/tatoeba/20191014/sentences-LANG-20191014-top1000.txt";

    private void run() throws IOException {
        for (Language lang : Languages.get()) {
            File file = new File(StringUtils.replaceOnce((String)template, (String)"LANG", (String)lang.getShortCode()));
            if (!file.exists() || file.length() == 0L) {
                System.err.println("File not found or empty, skipping: " + file);
                continue;
            }
            SentenceSourceChecker.main((String[])new String[]{"-l", lang.getShortCode(), "-f", file.getAbsolutePath()});
        }
    }

    public static void main(String[] args) throws IOException {
        new TatoebaEvaluator().run();
    }
}

