/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.errorcorpus.ErrorCorpus;
import org.languagetool.dev.errorcorpus.ErrorSentence;
import org.languagetool.dev.errorcorpus.SimpleCorpus;
import org.languagetool.dev.eval.Evaluator;
import org.languagetool.dev.eval.FMeasure;
import org.languagetool.dev.eval.PrecisionRecall;
import org.languagetool.dev.eval.Span;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.languagemodel.LuceneSingleIndexLanguageModel;
import org.languagetool.languagemodel.MultiLanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.EnglishNgramProbabilityRule;

public class SimpleCorpusEvaluator {
    private static final double START_THRESHOLD = 1.0E-6;
    private static final double END_THRESHOLD = 1.0E-17;
    private static final double STEP_FACTOR = 0.1;
    private static volatile EnglishNgramProbabilityRule probabilityRule;
    private final Evaluator evaluator;
    private int sentenceCount;
    private int errorsInCorpusCount;
    private int goodMatches;
    private int matchCount;

    public SimpleCorpusEvaluator(File indexTopDir) {
        this.evaluator = this.getEvaluator(indexTopDir);
    }

    public SimpleCorpusEvaluator(File ... indexTopDirs) {
        this.evaluator = this.getEvaluator(indexTopDirs);
    }

    @NotNull
    private Evaluator getEvaluator(File ... indexTopDirs) {
        return new NgramLanguageToolEvaluator(indexTopDirs);
    }

    @NotNull
    private ErrorCorpus getCorpus(File file) throws IOException {
        return new SimpleCorpus(file);
    }

    void close() {
        this.evaluator.close();
    }

    public PrecisionRecall run(File file, double threshold) throws IOException {
        probabilityRule.setMinProbability(threshold);
        this.checkLines(this.getCorpus(file));
        return this.printAndResetResults();
    }

    private void checkLines(ErrorCorpus corpus) throws IOException {
        for (ErrorSentence sentence : corpus) {
            List<RuleMatch> matches = this.evaluator.check(sentence.getAnnotatedText());
            ++this.sentenceCount;
            this.errorsInCorpusCount += sentence.getErrors().size();
            System.out.println(sentence.getMarkupText() + " => " + matches.size());
            for (RuleMatch match : matches) {
                int length = match.getToPos() - match.getFromPos();
                System.out.println(StringUtils.repeat((String)" ", (int)match.getFromPos()) + StringUtils.repeat((String)"^", (int)length));
            }
            ArrayList<Span> detectedErrorPositions = new ArrayList<Span>();
            int tmpGoodMatches = 0;
            for (RuleMatch match : matches) {
                boolean alreadyCounted = this.errorAlreadyCounted(match, detectedErrorPositions);
                if (!alreadyCounted && sentence.hasErrorCoveredByMatchAndGoodFirstSuggestion(match)) {
                    ++tmpGoodMatches;
                    ++this.matchCount;
                    System.out.println("    [++] " + match + ": " + match.getSuggestedReplacements());
                } else if (!alreadyCounted && sentence.hasErrorOverlappingWithMatch(match)) {
                    ++tmpGoodMatches;
                    ++this.matchCount;
                    System.out.println("    [+ ] " + match + ": " + match.getSuggestedReplacements());
                } else if (alreadyCounted) {
                    System.out.println("    [//]  " + match + ": " + match.getSuggestedReplacements());
                } else {
                    System.out.println("    [  ] " + match + ": " + match.getSuggestedReplacements());
                    ++this.matchCount;
                }
                detectedErrorPositions.add(new Span(match.getFromPos(), match.getToPos()));
            }
            this.goodMatches += Math.min(tmpGoodMatches, 1);
        }
    }

    private PrecisionRecall printAndResetResults() {
        System.out.println();
        System.out.println(this.sentenceCount + " lines checked with " + this.errorsInCorpusCount + " errors.");
        System.out.println("\nCounting matches, no matter whether the first suggestion is correct:");
        System.out.print("  " + this.goodMatches + " out of " + this.matchCount + " matches are real errors");
        float precision = (float)this.goodMatches / (float)this.matchCount;
        float recall = (float)this.goodMatches / (float)this.errorsInCorpusCount;
        double fMeasure = FMeasure.getFMeasure(precision, recall, 1.0f);
        System.out.printf(" => %.3f precision, %.3f recall, %.5f f-measure\n", Float.valueOf(precision), Float.valueOf(recall), fMeasure);
        this.sentenceCount = 0;
        this.errorsInCorpusCount = 0;
        this.goodMatches = 0;
        this.matchCount = 0;
        return new PrecisionRecall(precision, recall);
    }

    private boolean errorAlreadyCounted(RuleMatch match, List<Span> detectedErrorPositions) {
        for (Span span : detectedErrorPositions) {
            Span matchSpan;
            if (!span.covers(matchSpan = new Span(match.getFromPos(), match.getToPos())) && !matchSpan.covers(span)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + SimpleCorpusEvaluator.class.getSimpleName() + " <corpusFile> <languageModelDir>");
            System.out.println("   <languageModelDir> is a Lucene index directory with ngram frequency information (use comma but not space to specify more than one)");
            System.exit(1);
        }
        File inputFile = new File(args[0]);
        List<File> indexDirs = Arrays.stream(args[1].split(",")).map(File::new).collect(Collectors.toList());
        System.out.println("Running with language model from " + indexDirs);
        SimpleCorpusEvaluator evaluator = new SimpleCorpusEvaluator(indexDirs.toArray(new File[0]));
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        System.out.println("Output explanation:");
        System.out.println("    [  ] = this is not an expected error");
        System.out.println("    [+ ] = this is an expected error");
        System.out.println("    [++] = this is an expected error and the first suggestion is correct");
        System.out.println("    [//]  = not counted because already matches by a different rule");
        for (double threshold = 1.0E-6; threshold >= 1.0E-17; threshold *= 0.1) {
            System.out.println("========================================================================================================== " + threshold);
            PrecisionRecall res = evaluator.run(inputFile, threshold);
            String string = StringUtils.rightPad((String)String.valueOf(threshold), (int)22);
            double fMeasure = FMeasure.getFMeasure(res.getPrecision(), res.getRecall(), 1.0f);
            String fMeasureStr = String.format(Locale.ENGLISH, "%.3f", fMeasure);
            String precision = String.format(Locale.ENGLISH, "%.3f", Float.valueOf(res.getPrecision()));
            String recall = String.format(Locale.ENGLISH, "%.3f", Float.valueOf(res.getRecall()));
            results.add((CallSite)((Object)(string + ": f=" + fMeasureStr + ", precision=" + precision + ", recall=" + recall)));
        }
        System.out.println("=== Results: ==================================");
        for (String string : results) {
            System.out.println(string);
        }
        evaluator.close();
    }

    static class NgramLanguageToolEvaluator
    implements Evaluator {
        private final JLanguageTool lt = new JLanguageTool((Language)new English());
        private final LanguageModel languageModel;

        NgramLanguageToolEvaluator(File ... indexTopDirs) {
            this.disableAllRules();
            ArrayList<LuceneLanguageModel> lms = new ArrayList<LuceneLanguageModel>();
            for (File indexTopDir : indexTopDirs) {
                lms.add(new LuceneLanguageModel(indexTopDir));
            }
            this.languageModel = new MultiLanguageModel(lms);
            LuceneSingleIndexLanguageModel.clearCaches();
            System.out.println("Using Lucene language model from " + this.languageModel);
            probabilityRule = new EnglishNgramProbabilityRule(JLanguageTool.getMessageBundle(), this.languageModel, (Language)new English());
            probabilityRule.setDefaultOn();
            this.lt.addRule((Rule)probabilityRule);
        }

        @Override
        public void close() {
            if (this.languageModel != null) {
                this.languageModel.close();
            }
        }

        private void disableAllRules() {
            for (Rule rule : this.lt.getAllActiveRules()) {
                this.lt.disableRule(rule.getId());
            }
        }

        @Override
        public List<RuleMatch> check(AnnotatedText annotatedText) throws IOException {
            return this.lt.check(annotatedText);
        }
    }
}

