/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class ConfusionPairEvaluator {
    private static final String encoding = "UTF-8";
    static String[] words = new String[2];
    static String[] ruleIds = new String[2];
    static int[][] results = new int[2][4];
    static Language lang = null;
    static JLanguageTool lt = null;
    static List<String> classifyTypes = Arrays.asList("TP", "FP", "TN", "FN");

    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            ConfusionPairEvaluator.help();
        }
        long start = System.currentTimeMillis();
        lang = Languages.getLanguageForShortCode((String)args[0]);
        lt = new JLanguageTool(lang);
        String filename = args[1];
        ConfusionPairEvaluator.words[0] = args[2];
        ConfusionPairEvaluator.words[1] = args[3];
        ConfusionPairEvaluator.ruleIds[0] = args[4];
        ConfusionPairEvaluator.ruleIds[1] = args[5];
        for (Rule rule : lt.getAllRules()) {
            if (rule.getId().equals(ruleIds[0]) || rule.getId().equals(ruleIds[1])) continue;
            lt.disableRule(rule.getId());
        }
        try (InputStreamReader isr = ConfusionPairEvaluator.getInputStreamReader(filename, encoding);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                List sentencesLine = lt.sentenceTokenize(line);
                for (String sentence : sentencesLine) {
                    List tokens = lang.getWordTokenizer().tokenize(sentence);
                    int count0 = 0;
                    int count1 = 0;
                    for (String token : tokens) {
                        if (token.equals(words[0])) {
                            ++count0;
                        }
                        if (!token.equals(words[1])) continue;
                        ++count1;
                    }
                    if (count0 > 0 && count1 > 0) {
                        System.out.println("WARNING Sentence with the two words: " + sentence);
                        continue;
                    }
                    if (count0 == 1 && count1 == 0) {
                        ConfusionPairEvaluator.analyzeSentence(sentence, 0);
                        continue;
                    }
                    if (count0 == 0 && count1 == 1) {
                        ConfusionPairEvaluator.analyzeSentence(sentence, 1);
                        continue;
                    }
                    if (count0 <= 1 && count1 <= 1) continue;
                    System.out.println("WARNING Sentence with a repeated word: " + sentence);
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            System.out.println("Results for rule " + ruleIds[i]);
            for (int j = 0; j < 4; ++j) {
                System.out.println(classifyTypes.get(j) + ": " + results[i][j]);
            }
            float precision = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FP")]);
            float recall = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FN")]);
            System.out.println("Precision: " + String.format("%.4f", Float.valueOf(precision)));
            System.out.println("Recall: " + String.format("%.4f", Float.valueOf(recall)));
        }
        float time = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        System.out.println("Total time: " + String.format("%.2f", Float.valueOf(time)) + " seconds");
    }

    private static void analyzeSentence(String correctSentence, int j) throws IOException {
        List matchesCorrect = lt.check(correctSentence);
        if (ConfusionPairEvaluator.containsID(matchesCorrect, ruleIds[j])) {
            int[] nArray = results[j];
            int n = classifyTypes.indexOf("FP");
            nArray[n] = nArray[n] + 1;
            System.out.println(ruleIds[j] + " FP: " + correctSentence);
        } else {
            int[] nArray = results[j];
            int n = classifyTypes.indexOf("TN");
            nArray[n] = nArray[n] + 1;
        }
        String wrongSentence = correctSentence.replaceAll("\\b" + words[j] + "\\b", words[1 - j]);
        List matchesWrong = lt.check(wrongSentence);
        if (ConfusionPairEvaluator.containsID(matchesWrong, ruleIds[1 - j])) {
            int[] nArray = results[1 - j];
            int n = classifyTypes.indexOf("TP");
            nArray[n] = nArray[n] + 1;
        } else {
            int[] nArray = results[1 - j];
            int n = classifyTypes.indexOf("FN");
            nArray[n] = nArray[n] + 1;
            System.out.println(ruleIds[1 - j] + " FN: " + wrongSentence);
        }
    }

    private static boolean containsID(List<RuleMatch> matches, String id) {
        for (RuleMatch match : matches) {
            if (!match.getRule().getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private int indexOfWord(String word, String sentence) {
        Pattern p = Pattern.compile("\\b" + word + "\\b");
        Matcher m = p.matcher(sentence);
        if (m != null) {
            return m.start();
        }
        return -1;
    }

    private static InputStreamReader getInputStreamReader(String filename, String encoding) throws IOException {
        String charsetName = encoding != null ? encoding : Charset.defaultCharset().name();
        InputStream is = System.in;
        if (!ConfusionPairEvaluator.isStdIn(filename)) {
            is = new FileInputStream(new File(filename));
            BOMInputStream bomIn = new BOMInputStream(is, true, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            if (bomIn.hasBOM() && encoding == null) {
                charsetName = bomIn.getBOMCharsetName();
            }
            is = bomIn;
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(is), charsetName);
    }

    private static boolean isStdIn(String filename) {
        return "-".equals(filename);
    }

    private static void help() {
        System.out.println("Usage: " + ConfusionPairEvaluator.class.getSimpleName() + " <language code> <intput file> word1 word2 ruleId1 ruleId2");
        System.exit(1);
    }
}

