/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.tools.StringTools;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class AfterTheDeadlineEvaluator {
    private static final int WAIT_TIME_MILLIS = 1000;
    private final String urlPrefix;

    AfterTheDeadlineEvaluator(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    private void run(Language lang) throws IOException, InterruptedException {
        List<Rule> rules = this.getRules(lang);
        int sentenceCount = 0;
        int errorFoundCount = 0;
        System.out.println("Starting test for " + lang.getName() + " on " + this.urlPrefix);
        System.out.println("Wait time between HTTP requests: 1000ms");
        System.out.println("Starting test on " + rules.size() + " rules");
        for (Rule rule : rules) {
            if (rule.isDefaultOff()) {
                System.out.println("Skipping rule that is off by default: " + rule.getId());
                continue;
            }
            List incorrectExamples = rule.getIncorrectExamples();
            System.out.println("\n" + rule.getId() + ":");
            if (incorrectExamples.isEmpty()) {
                System.out.println(" (no examples)");
                continue;
            }
            for (IncorrectExample example : incorrectExamples) {
                boolean match = this.queryAtDServer(example);
                ++sentenceCount;
                if (match) {
                    ++errorFoundCount;
                }
                String marker = match ? "+" : "-";
                System.out.println("  [" + marker + "] " + example.getExample().replace("<marker>", "<m>").replace("</marker>", "</m>"));
                Thread.sleep(1000L);
            }
        }
        System.out.println("\nDone.");
        System.out.println("Sentence count: " + sentenceCount);
        float percentage = (float)errorFoundCount / (float)sentenceCount * 100.0f;
        System.out.printf("Expected errors found: " + errorFoundCount + " (%.2f%%)\n", Float.valueOf(percentage));
    }

    private List<Rule> getRules(Language lang) throws IOException {
        JLanguageTool lt = new JLanguageTool(lang);
        return lt.getAllActiveRules();
    }

    private boolean queryAtDServer(IncorrectExample example) {
        String sentence = ExampleSentence.cleanMarkersInExample((String)example.getExample());
        try {
            URL url = new URL(this.urlPrefix + URLEncoder.encode(sentence, "UTF-8"));
            String result = this.getContent(url);
            if (this.isExpectedErrorFound(example, result)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private String getContent(URL url) throws IOException {
        InputStream contentStream = (InputStream)url.getContent();
        return StringTools.streamToString((InputStream)contentStream, (String)"UTF-8");
    }

    boolean isExpectedErrorFound(IncorrectExample incorrectExample, String resultXml) throws XPathExpressionException {
        String example = incorrectExample.getExample();
        Document document = this.getDocument(resultXml);
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList errorStrings = (NodeList)xPath.evaluate("//string/text()", document, XPathConstants.NODESET);
        for (int i = 0; i < errorStrings.getLength(); ++i) {
            String errorStr = errorStrings.item(i).getNodeValue();
            if (errorStr.isEmpty()) continue;
            List<Integer> errorStartPosList = this.getStartPositions(incorrectExample, errorStr);
            ArrayList<CallSite> mismatches = new ArrayList<CallSite>();
            for (Integer n : errorStartPosList) {
                int errorEndPos = n + errorStr.length();
                int expectedErrorStartPos = example.indexOf("<marker>");
                int expectedErrorEndPos = n + errorStr.length();
                if (n == expectedErrorStartPos && errorEndPos == expectedErrorEndPos) {
                    return true;
                }
                mismatches.add((CallSite)((Object)("Position mismatch: " + n + "-" + errorEndPos + " != " + expectedErrorStartPos + "-" + expectedErrorEndPos)));
            }
            for (String string : mismatches) {
                System.out.println("  " + string);
            }
        }
        return false;
    }

    private List<Integer> getStartPositions(IncorrectExample example, String searchStr) {
        ArrayList<Integer> posList = new ArrayList<Integer>();
        int pos = 0;
        String sentence = ExampleSentence.cleanMarkersInExample((String)example.getExample());
        while ((pos = sentence.indexOf(searchStr, pos)) != -1) {
            posList.add(pos);
            ++pos;
        }
        return posList;
    }

    private Document getDocument(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(xml));
            return builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML: " + xml);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + AfterTheDeadlineEvaluator.class.getSimpleName() + " <langCode> <urlPrefix>");
            System.err.println("  <urlPrefix> After the Deadline instance, e.g. 'http://de.service.afterthedeadline.com/checkDocument?key=test&data='");
            System.exit(1);
        }
        AfterTheDeadlineEvaluator evaluator = new AfterTheDeadlineEvaluator(args[1]);
        evaluator.run(Languages.getLanguageForShortCode((String)args[0]));
    }
}

