/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.diff;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.dev.diff.DiffTools;

class LightRuleMatch {
    private final int line;
    private final int column;
    private final String fullRuleId;
    private final String message;
    private final String category;
    private final String context;
    private final String coveredText;
    private final List<String> suggestions;
    private final String ruleSource;
    private final String title;
    private final Status status;
    private final List<String> tags;
    private final boolean isPremium;

    LightRuleMatch(int line, int column, String ruleId, String message, String category, String context, String coveredText, List<String> suggestions, String ruleSource, String title, Status status, List<String> tags, boolean isPremium) {
        this.line = line;
        this.column = column;
        this.fullRuleId = Objects.requireNonNull(ruleId);
        this.message = Objects.requireNonNull(message);
        this.category = Objects.requireNonNull(category);
        this.context = Objects.requireNonNull(context);
        this.coveredText = Objects.requireNonNull(coveredText);
        this.suggestions = suggestions == null ? Arrays.asList(new String[0]) : suggestions;
        this.ruleSource = ruleSource;
        this.title = title;
        this.status = Objects.requireNonNull(status);
        this.tags = Objects.requireNonNull(tags);
        this.isPremium = isPremium;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    String getFullRuleId() {
        return this.fullRuleId;
    }

    String getRuleId() {
        return DiffTools.getMasterId(this.fullRuleId);
    }

    @Nullable
    String getSubId() {
        return DiffTools.getSubId(this.fullRuleId);
    }

    String getMessage() {
        return this.message;
    }

    String getCategoryName() {
        return this.category;
    }

    String getContext() {
        return this.context;
    }

    String getCoveredText() {
        return this.coveredText;
    }

    List<String> getSuggestions() {
        return this.suggestions;
    }

    @Nullable
    String getRuleSource() {
        return this.ruleSource;
    }

    @Nullable
    String getTitle() {
        return this.title;
    }

    Status getStatus() {
        return this.status;
    }

    List<String> getTags() {
        return this.tags;
    }

    boolean isPremium() {
        return this.isPremium;
    }

    public String toString() {
        return this.line + "/" + this.column + " " + this.getRuleId() + "[" + this.getSubId() + "], msg=" + this.message + ", covered=" + this.coveredText + ", suggestions=" + this.suggestions + ", title=" + this.title + ", ctx=" + this.context;
    }

    static enum Status {
        temp_off,
        on;

    }
}

