/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

class TextIndexCreator {
    TextIndexCreator() {
    }

    private void index(File outputDir, String[] inputFiles) throws IOException {
        StandardAnalyzer analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
        try (FSDirectory directory = FSDirectory.open((Path)outputDir.toPath());
             IndexWriter indexWriter = new IndexWriter((Directory)directory, config);){
            for (String inputFile : inputFiles) {
                this.indexFile(indexWriter, inputFile);
            }
        }
    }

    private void indexFile(IndexWriter indexWriter, String inputFile) throws IOException {
        System.out.println("Indexing " + inputFile);
        int lineCount = 0;
        try (Scanner scanner = new Scanner(new File(inputFile));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Document doc = new Document();
                doc.add((IndexableField)new TextField("field", line, Field.Store.YES));
                doc.add((IndexableField)new TextField("fieldLowercase", line.toLowerCase(), Field.Store.YES));
                indexWriter.addDocument((Iterable)doc);
                if (++lineCount % 10000 != 0) continue;
                System.out.println(lineCount + "...");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: " + TextIndexCreator.class.getSimpleName() + " <outputDir> <inputFile...>");
            System.exit(0);
        }
        TextIndexCreator creator = new TextIndexCreator();
        File outputDir = new File(args[0]);
        if (outputDir.exists()) {
            throw new RuntimeException("Output directory already exists: " + outputDir);
        }
        creator.index(outputDir, Arrays.copyOfRange(args, 1, args.length));
    }
}

