/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class OccurrenceAdder {
    private static final int BUFFER_SIZE = 16384;

    private void run(Map<String, Integer> map, File dir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            this.runOnFile(map, file);
        }
    }

    private void runOnFile(Map<String, Integer> map, File file) throws IOException {
        System.out.println("Working on " + file);
        try (FileInputStream fileStream = new FileInputStream(file);
             GZIPInputStream gzipStream = new GZIPInputStream((InputStream)fileStream, 16384);
             InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "utf-8");
             BufferedReader buffered = new BufferedReader(decoder, 16384);){
            String line;
            while ((line = buffered.readLine()) != null) {
                String[] parts = line.split("\t");
                String word = parts[0];
                int occurrences = Integer.parseInt(parts[2]);
                Integer val = map.get(word);
                if (val == null) continue;
                map.put(word, val + occurrences);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + OccurrenceAdder.class.getName() + " <wordfile> <dir>");
            System.exit(1);
        }
        OccurrenceAdder occurrenceAdder = new OccurrenceAdder();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List words = IOUtils.readLines((InputStream)new FileInputStream(args[0]));
        for (String string : words) {
            map.put(string, 0);
        }
        occurrenceAdder.run(map, new File(args[1]));
        System.out.println("-------------------------");
        for (Map.Entry entry : map.entrySet()) {
            System.out.println(entry.getValue() + "\t" + (String)entry.getKey());
        }
    }
}

