/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

final class LuceneSimpleIndexCreator {
    private LuceneSimpleIndexCreator() {
    }

    public static void main(String[] args) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        try (IndexWriter iw1 = new IndexWriter((Directory)FSDirectory.open((Path)new File("/tmp/1grams").toPath()), conf);){
            LuceneSimpleIndexCreator.addDoc(iw1, "the", 55);
            LuceneSimpleIndexCreator.addDoc(iw1, "nice", 10);
            LuceneSimpleIndexCreator.addDoc(iw1, "building", 1);
            Document document = new Document();
            document.add((IndexableField)new TextField("totalTokenCount", String.valueOf(3), Field.Store.YES));
            iw1.addDocument((Iterable)document);
        }
        IndexWriterConfig conf2 = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        try (IndexWriter iw2 = new IndexWriter((Directory)FSDirectory.open((Path)new File("/tmp/2grams").toPath()), conf2);){
            LuceneSimpleIndexCreator.addDoc(iw2, "the nice", 3);
            LuceneSimpleIndexCreator.addDoc(iw2, "nice building", 2);
        }
        IndexWriterConfig conf3 = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        try (IndexWriter iw3 = new IndexWriter((Directory)FSDirectory.open((Path)new File("/tmp/3grams").toPath()), conf3);){
            LuceneSimpleIndexCreator.addDoc(iw3, "the nice building", 1);
        }
    }

    private static void addDoc(IndexWriter iw, String ngram, int count) throws IOException {
        Document document = new Document();
        document.add((IndexableField)new TextField("ngram", ngram, Field.Store.YES));
        document.add((IndexableField)new TextField("count", String.valueOf(count), Field.Store.YES));
        iw.addDocument((Iterable)document);
    }
}

