/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;

public class ContextBuilder {
    private final String startMarker;
    private final String endMarker;

    public ContextBuilder() {
        this.startMarker = "_START_";
        this.endMarker = "_END_";
    }

    public ContextBuilder(String startMarker, String endMarker) {
        this.startMarker = startMarker;
        this.endMarker = endMarker;
    }

    public List<String> getContext(AnalyzedTokenReadings[] tokens, int pos, int contextSize) {
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        for (AnalyzedTokenReadings token : tokens) {
            if (i == pos) {
                l.addAll(this.getLeftContext(tokens, pos, contextSize));
                l.add(token.getToken());
                l.addAll(this.getRightContext(tokens, pos, contextSize));
                break;
            }
            ++i;
        }
        return l;
    }

    private List<String> getLeftContext(AnalyzedTokenReadings[] tokens, int pos, int contextSize) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = pos - 1; i >= 0 && l.size() < contextSize; --i) {
            if (i == 0) {
                l.add(0, this.startMarker);
                continue;
            }
            l.add(0, tokens[i].getToken());
        }
        return l;
    }

    private List<String> getRightContext(AnalyzedTokenReadings[] tokens, int pos, int contextSize) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = pos + 1; i <= tokens.length && l.size() < contextSize; ++i) {
            if (i == tokens.length) {
                l.add(this.endMarker);
                continue;
            }
            l.add(tokens[i].getToken());
        }
        return l;
    }
}

