/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Scanner;
import org.languagetool.languagemodel.LuceneLanguageModel;

final class ConfusionSetOccurrenceLookup {
    private ConfusionSetOccurrenceLookup() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + ConfusionSetOccurrenceLookup.class.getName() + " <confusion-file> <ngram-data-dir>");
            System.exit(1);
        }
        try (Scanner sc = new Scanner(new File(args[0]));
             LuceneLanguageModel lm = new LuceneLanguageModel(new File(args[1]));){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                String[] words = line.split(";\\s*");
                long total = 0L;
                ArrayList<Long> counts = new ArrayList<Long>();
                StringBuilder sb = new StringBuilder();
                for (String word : words) {
                    long count = lm.getCount(word);
                    total += count;
                    sb.append(word).append(':').append(count).append(' ');
                    counts.add(count);
                }
                float factor = (float)((Long)Collections.max(counts)).longValue() / (float)((Long)Collections.min(counts)).longValue();
                System.out.printf(Locale.ENGLISH, total + " " + line + "    " + sb.toString().trim() + " factor:%.1f\n", Float.valueOf(factor));
            }
        }
    }
}

