/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ConfusionSetFileFormatter {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + ConfusionSetFileFormatter.class.getSimpleName() + " <confusion_set.txt>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        for (String line : lines) {
            System.out.println(ConfusionSetFileFormatter.reformat(line));
        }
    }

    private static String reformat(String s) {
        Pattern pattern = Pattern.compile(";\\s*\\d+");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            int spaceStart = matcher.end();
            int spaceEnd = s.indexOf(35, 2);
            if (spaceStart > 0 && spaceEnd > 0) {
                String spaces = StringUtils.repeat((String)" ", (int)(52 - spaceStart));
                return s.substring(0, spaceStart + 1) + spaces + s.substring(spaceEnd);
            }
        }
        return s;
    }
}

