/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.languagetool.Language;
import org.languagetool.Languages;

class XmlUsageCounter {
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    XmlUsageCounter() {
    }

    private void countElementsAndAttributes(InputStream in) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement()) continue;
            String elementName = event.asStartElement().getName().getLocalPart();
            this.add(elementName);
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute att = attributes.next();
                this.add(elementName + "/" + att.getName());
            }
        }
    }

    private void add(String name) {
        if (this.map.containsKey(name)) {
            int oldCount = this.map.get(name);
            this.map.put(name, oldCount + 1);
        } else {
            this.map.put(name, 1);
        }
    }

    private void printResult() {
        ArrayList<ElemCount> elemCounts = new ArrayList<ElemCount>();
        for (Map.Entry<String, Integer> entry : this.map.entrySet()) {
            elemCounts.add(new ElemCount(entry.getKey(), entry.getValue()));
        }
        Collections.sort(elemCounts, (ec1, ec2) -> ec2.count - ec1.count);
        for (ElemCount elemCount : elemCounts) {
            System.out.println(elemCount.count + " " + elemCount.elem);
        }
    }

    public static void main(String[] args) throws XMLStreamException {
        XmlUsageCounter counter = new XmlUsageCounter();
        HashSet<String> countedFiles = new HashSet<String>();
        for (Language language : Languages.get()) {
            List ruleFileNames = language.getRuleFileNames();
            for (String ruleFileName : ruleFileNames) {
                if (countedFiles.contains(ruleFileName)) continue;
                System.err.println("Counting elements for " + ruleFileName);
                InputStream ruleStream = XmlUsageCounter.class.getResourceAsStream(ruleFileName);
                if (ruleStream == null) {
                    System.err.println("Not found, ignoring: " + ruleFileName);
                    continue;
                }
                counter.countElementsAndAttributes(ruleStream);
                countedFiles.add(ruleFileName);
            }
        }
        counter.printResult();
    }

    static class ElemCount {
        String elem;
        Integer count;

        ElemCount(String elem, Integer count) {
            this.elem = elem;
            this.count = count;
        }
    }
}

