/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class UnknownWordFinderForCsv {
    private void run(File dir, JLanguageTool lt) throws IOException {
        SpellingCheckRule spellerRule = this.getSpellingCheckRule(lt);
        List files = Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path file : files) {
            this.handle(file, spellerRule);
        }
    }

    @NotNull
    private SpellingCheckRule getSpellingCheckRule(JLanguageTool lt) {
        SpellingCheckRule spellerRule = null;
        for (Rule rule : lt.getAllActiveRules()) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            if (spellerRule != null) {
                throw new RuntimeException("Found more than one spell rule: " + rule + ", " + spellerRule);
            }
            spellerRule = (SpellingCheckRule)rule;
        }
        if (spellerRule == null) {
            throw new RuntimeException("No speller rule found for " + lt.getLanguage());
        }
        return spellerRule;
    }

    private void handle(Path f, SpellingCheckRule rule) throws IOException {
        int i = 0;
        if (f.toString().toLowerCase().endsWith(".csv")) {
            List<String> lines = Files.readAllLines(f);
            for (String line : lines) {
                String[] parts = line.split(",");
                String word = parts[0].replace("\"", "");
                if (!rule.isMisspelled(word)) continue;
                System.out.println(line);
                ++i;
            }
        } else {
            System.out.println("Ignoring " + f + ": unknown suffix");
        }
        System.out.println("Lines printed: " + i);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + UnknownWordFinderForCsv.class.getSimpleName() + " <langCode> <dir>");
            System.exit(1);
        }
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)args[0]));
        new UnknownWordFinderForCsv().run(new File(args[1]), lt);
    }
}

