/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tools.StringTools;

public class MissingGermanWords {
    private final String filename;
    private final boolean outputCombinedListing;
    private final GermanSpellerRule germanSpeller;
    private final GermanTagger germanTagger;
    private final MorfologikAmericanSpellerRule englishSpeller;

    public MissingGermanWords(String filename) throws IOException {
        this.filename = filename;
        this.outputCombinedListing = true;
        this.germanSpeller = new GermanSpellerRule(JLanguageTool.getMessageBundle(), GermanyGerman.getInstance());
        this.germanTagger = new GermanTagger();
        this.englishSpeller = new MorfologikAmericanSpellerRule(JLanguageTool.getMessageBundle(), (Language)AmericanEnglish.getInstance());
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + MissingGermanWords.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        String filename = args[0];
        new MissingGermanWords(filename).run();
    }

    private void run() throws IOException {
        if (this.outputCombinedListing) {
            this.listMissingWords(this.filename);
        } else {
            this.listMissingWordsSpeller(this.filename);
            this.listMissingWordsTagger(this.filename);
        }
    }

    private void listMissingWordsSpeller(String filename) throws IOException {
        String line;
        System.out.println("# missing words speller");
        BufferedReader reader = this.getReaderForFilename(filename);
        while ((line = reader.readLine()) != null) {
            String word = this.wordFromLine(line);
            if (this.isKnownByGermanSpeller(word) || this.isKnownByEnglishSpeller(word)) continue;
            System.out.println(line);
        }
        reader.close();
    }

    private void listMissingWordsTagger(String filename) throws IOException {
        String line;
        System.out.println("# missing words tagger");
        BufferedReader reader = this.getReaderForFilename(filename);
        while ((line = reader.readLine()) != null) {
            String word = this.wordFromLine(line);
            if (this.isKnownByGermanTagger(word) || this.isKnownByEnglishSpeller(word)) continue;
            System.out.println(line);
        }
        reader.close();
    }

    private void listMissingWords(String filename) throws IOException {
        String line;
        BufferedReader reader = this.getReaderForFilename(filename);
        while ((line = reader.readLine()) != null) {
            String word = this.wordFromLine(line);
            boolean knownBySpeller = this.isKnownByGermanSpeller(word);
            boolean knownByTagger = this.isKnownByGermanTagger(word);
            if (knownBySpeller && knownByTagger || this.isKnownByEnglishSpeller(word)) continue;
            System.out.print(line);
            System.out.print(",");
            if (!knownBySpeller && !knownByTagger) {
                System.out.println("speller+tagger");
                continue;
            }
            if (!knownBySpeller) {
                System.out.println("speller");
                continue;
            }
            System.out.println("tagger");
        }
        reader.close();
    }

    private boolean isKnownByGermanSpeller(String word) {
        return !this.germanSpeller.isMisspelled(StringTools.uppercaseFirstChar((String)word)) || !this.germanSpeller.isMisspelled(StringTools.lowercaseFirstChar((String)word));
    }

    private boolean isKnownByGermanTagger(String word) throws IOException {
        return this.germanTagger.lookup(StringTools.uppercaseFirstChar((String)word)) != null || this.germanTagger.lookup(StringTools.lowercaseFirstChar((String)word)) != null;
    }

    private boolean isKnownByEnglishSpeller(String word) throws IOException {
        return !this.englishSpeller.isMisspelled(StringTools.uppercaseFirstChar((String)word)) || !this.englishSpeller.isMisspelled(StringTools.lowercaseFirstChar((String)word));
    }

    private BufferedReader getReaderForFilename(String filename) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        return new BufferedReader(isr);
    }

    private String wordFromLine(String line) {
        return line.split(",")[0];
    }
}

