/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.tagging.de.GermanTagger;

public class MissingGermanPosFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + MissingGermanPosFinder.class.getSimpleName() + " <file> <ngram_dir>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        LuceneLanguageModel lm = new LuceneLanguageModel(new File(args[1]));
        GermanTagger tagger = new GermanTagger();
        for (String word : lines) {
            int origCount = -1;
            if (word.matches("\\d+ .*")) {
                String[] parts = word.split(" ");
                origCount = Integer.parseInt(parts[0]);
                word = parts[1];
            }
            if ((word = word.trim()).endsWith(".")) {
                word = word.substring(0, word.length() - 1);
            }
            AnalyzedTokenReadings matches = tagger.lookup(word);
            AnalyzedTokenReadings lcMatches = tagger.lookup(word.toLowerCase());
            if (matches != null && matches.isTagged() || lcMatches != null && lcMatches.isTagged()) continue;
            long count = origCount == -1 ? lm.getCount(word) : (long)origCount;
            System.out.println(count + "\t" + word);
        }
    }
}

