/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.tagging.ga.Utils;

public class GenerateIrishWordforms {
    private static final Map<String, String[]> nounGuesses = new HashMap<String, String[]>();
    private static final String NOUN_ENDINGS_REGEX;
    private static final Pattern NOUN_PATTERN;
    private static final String[] BASEFORMS;

    public static void writeFromGuess(String word) {
        Matcher m = NOUN_PATTERN.matcher(word);
        if (m.find()) {
            String stem = m.group(1);
            String ending = m.group(2);
            String[] endings = nounGuesses.get(ending);
            Map<String, String> forms = GenerateIrishWordforms.expandNounForms(stem, endings);
            Map<String, String> tags = GenerateIrishWordforms.getIrishFSTTags(forms);
            for (String s : tags.keySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(forms.get(s));
                sb.append('\t');
                sb.append(word);
                sb.append('\t');
                sb.append(tags.get(s));
                System.out.println(sb.toString());
            }
        }
    }

    public static Map<String, String> expandNounForms(String stem, String[] parts) {
        String gender = parts[0];
        String nounClass = "";
        if (parts[0].matches("[mf][0-9]")) {
            gender = parts[0].substring(0, 1);
            nounClass = parts[0].substring(1);
        }
        if (nounClass.equals("")) {
            String irishFSTOut = GenerateIrishWordforms.getIrishFSTNounClass(parts[1]);
            nounClass = irishFSTOut.substring(2, 1);
        }
        HashMap<String, String> forms = new HashMap<String, String>();
        forms.put("stem", stem);
        forms.put("pos", "n");
        forms.put("class", gender + nounClass);
        forms.put("gender", gender);
        forms.put("sg.nom", stem + parts[1]);
        forms.put("sg.gen", stem + parts[2]);
        forms.put("pl.nom", stem + parts[3]);
        forms.put("pl.gen", stem + parts[4]);
        GenerateIrishWordforms.addMutatedForms(forms);
        if (nounClass.equals("3") || nounClass.equals("4")) {
            forms.put("sg.voc.len", (String)forms.get("sg.nom.len"));
            forms.put("pl.voc.len", (String)forms.get("pl.nom.len"));
        }
        for (String bf : BASEFORMS) {
            forms.put(bf + ".defart", GenerateIrishWordforms.mutate((String)forms.get(bf), GenerateIrishWordforms.getDefArtMutation(gender, bf)));
        }
        Object genderForDefArt = gender;
        if (Utils.isVowel((char)stem.charAt(0))) {
            genderForDefArt = (String)genderForDefArt + "v";
        } else if (stem.toLowerCase().charAt(0) == 's' && stem.length() >= 2 && Utils.isSLenitable((char)stem.charAt(1))) {
            genderForDefArt = (String)genderForDefArt + "s";
        }
        return forms;
    }

    private static Map<String, String> getIrishFSTTags(Map<String, String> forms) {
        HashMap<String, String> out = new HashMap<String, String>();
        boolean strong = forms.get("pl.nom").equals(forms.get("pl.gen"));
        StringBuilder builder = new StringBuilder();
        if (forms.get("pos").equals("n")) {
            builder.append("Noun");
        }
        if (forms.get("gender").equals("m")) {
            builder.append(":Masc");
        } else if (forms.get("gender").equals("f")) {
            builder.append(":Fem");
        }
        String base = builder.toString();
        for (String k : forms.keySet()) {
            if (!k.startsWith("sg") && !k.startsWith("pl")) continue;
            String[] tagParts = k.split("\\.");
            StringBuilder sb = new StringBuilder();
            sb.append(base);
            if (k.startsWith("pl.gen")) {
                sb.append(":Gen");
                if (strong) {
                    sb.append(":Strong");
                } else {
                    sb.append(":Weak");
                }
                sb.append(":Pl");
                sb.append(GenerateIrishWordforms.morphTag(k));
            } else {
                sb.append(':');
                sb.append(tagParts[1].toUpperCase().charAt(0));
                sb.append(tagParts[1].substring(1));
                sb.append(':');
                sb.append(tagParts[0].toUpperCase().charAt(0));
                sb.append(tagParts[0].substring(1));
                sb.append(GenerateIrishWordforms.morphTag(k));
            }
            out.put(k, sb.toString());
        }
        return out;
    }

    private static String morphTag(String s) {
        if (s.endsWith(".len")) {
            return ":Len";
        }
        if (s.endsWith(".ecl")) {
            return ":Ecl";
        }
        if (s.endsWith(".hpref")) {
            return ":hPref";
        }
        if (s.endsWith(".defart")) {
            return ":DefArt";
        }
        return "";
    }

    private static void addMutatedForms(Map<String, String> map) {
        String key;
        for (String s : BASEFORMS) {
            key = s + ".len";
            String len = Utils.lenite((String)map.get(s));
            map.put(key, len);
        }
        for (String s : BASEFORMS) {
            key = s + ".ecl";
            String ecl = Utils.eclipse((String)map.get(s));
            map.put(key, ecl);
        }
        for (String s : BASEFORMS) {
            if (!Utils.isVowel((char)map.get(s).charAt(0))) continue;
            map.put(s + ".hpref", "h" + map.get(s));
        }
    }

    private static String mutate(String word, String mutation) {
        if (mutation == null) {
            return word;
        }
        if (mutation.equals("len")) {
            return Utils.lenite((String)word);
        }
        if (mutation.equals("ecl")) {
            return Utils.eclipse((String)word);
        }
        if (mutation.equals("hpref")) {
            return "h" + word;
        }
        return word;
    }

    public static String guessIrishFSTNounClassSimple(String ending) {
        Matcher m = NOUN_PATTERN.matcher(ending);
        if (m.find()) {
            return GenerateIrishWordforms.getIrishFSTNounClass(m.group(2));
        }
        return "";
    }

    static String getIrishFSTNounClass(String ending) {
        switch (ending) {
            case "\u00f3ir": 
            case "eoir": 
            case "\u00e9ir": 
            case "\u00fair": 
            case "aeir": {
                return "Nm3-1";
            }
            case "\u00e1la\u00ed": 
            case "e\u00e1la\u00ed": {
                return "Nm4-4";
            }
        }
        return null;
    }

    static String getIrishFSTAdjClass(String ending) {
        switch (ending) {
            case "i\u00fail": 
            case "\u00fail": {
                return "Adj2-1";
            }
            case "each": 
            case "ach": {
                return "Adj3-1";
            }
            case "a\u00edoch": 
            case "\u00edoch": {
                return "Adj1-4";
            }
        }
        return "";
    }

    private static String getDefArtMutation(String gender, String form) {
        if (gender.equals("f")) {
            switch (form) {
                case "nom.sg": {
                    return "len";
                }
                case "nom.pl": {
                    return "";
                }
                case "gen.sg": {
                    return "";
                }
                case "gen.pl": {
                    return "ecl";
                }
                case "voc.pl": {
                    return "";
                }
            }
        } else if (gender.equals("fv")) {
            switch (form) {
                case "nom.sg": {
                    return "";
                }
                case "nom.pl": {
                    return "hpref";
                }
                case "gen.sg": {
                    return "hpref";
                }
                case "gen.pl": {
                    return "ecl";
                }
                case "voc.pl": {
                    return "";
                }
            }
        } else if (gender.equals("fs")) {
            switch (form) {
                case "nom.pl": 
                case "gen.sg": 
                case "gen.pl": 
                case "voc.pl": {
                    return "";
                }
                case "nom.sg": {
                    return "tpref";
                }
            }
        } else if (gender.equals("m")) {
            switch (form) {
                case "nom.sg": {
                    return "";
                }
                case "nom.pl": {
                    return "";
                }
                case "gen.sg": {
                    return "len";
                }
                case "gen.pl": {
                    return "ecl";
                }
                case "voc.pl": {
                    return "";
                }
            }
        } else if (gender.equals("mv")) {
            switch (form) {
                case "nom.sg": {
                    return "tpref";
                }
                case "nom.pl": {
                    return "hpref";
                }
                case "gen.sg": {
                    return "hpref";
                }
                case "gen.pl": {
                    return "ecl";
                }
                case "voc.pl": {
                    return "";
                }
            }
        } else if (gender.equals("ms")) {
            switch (form) {
                case "nom.sg": 
                case "nom.pl": 
                case "gen.pl": 
                case "voc.pl": {
                    return "";
                }
                case "gen.sg": {
                    return "tpref";
                }
            }
        }
        return null;
    }

    public static Map<String, String> extractEnWiktionaryNounTemplate(String tpl) {
        int end;
        HashMap<String, String> out = new HashMap<String, String>();
        if (!tpl.contains("{{") && !tpl.contains("}}")) {
            return out;
        }
        int start = tpl.indexOf("{{") + 2;
        String inner = tpl.substring(start, end = tpl.indexOf("}}", start));
        String[] parts = inner.split("\\|");
        if (parts[0].equals("ga-decl-m3") && parts.length >= 4) {
            out.put("class", "m3");
            out.put("stem", parts[1]);
            out.put("sg.nom", parts[2]);
            out.put("sg.gen", parts[3]);
            if (parts.length == 4) {
                out.put("pl.nom", parts[3]);
                out.put("pl.gen", parts[3]);
            } else if (parts.length == 5) {
                out.put("pl.nom", parts[3]);
                out.put("pl.gen", parts[4]);
            } else if (parts.length == 6) {
                out.put("pl.nom", parts[4]);
                out.put("pl.gen", parts[5]);
            }
        }
        return out;
    }

    static String getEndingsRegex(Map<String, String[]> map) {
        ArrayList<String> endings = new ArrayList<String>(map.size());
        endings.addAll(map.keySet());
        Collections.sort(endings, Comparator.comparingInt(String::length).reversed());
        return "(.+)(" + String.join((CharSequence)"|", endings) + ")$";
    }

    static {
        nounGuesses.put("\u00f3ir", new String[]{"m3", "\u00f3ir", "\u00f3ra", "\u00f3ir\u00ed", "\u00f3ir\u00ed"});
        nounGuesses.put("eoir", new String[]{"m3", "eoir", "eora", "eoir\u00ed", "eoir\u00ed"});
        nounGuesses.put("\u00e9ir", new String[]{"m3", "\u00e9ir", "\u00e9ara", "\u00e9ir\u00ed", "\u00e9ir\u00ed"});
        nounGuesses.put("\u00fair", new String[]{"m3", "\u00fair", "\u00fara", "\u00fair\u00ed", "\u00fair\u00ed"});
        nounGuesses.put("aeir", new String[]{"m3", "aeir", "aera", "aeir\u00ed", "aeir\u00ed"});
        nounGuesses.put("\u00e1la\u00ed", new String[]{"m4", "\u00e1la\u00ed", "\u00e1la\u00ed", "\u00e1laithe", "\u00e1laithe"});
        nounGuesses.put("e\u00e1la\u00ed", new String[]{"m4", "e\u00e1la\u00ed", "e\u00e1la\u00ed", "e\u00e1laithe", "e\u00e1laithe"});
        NOUN_ENDINGS_REGEX = GenerateIrishWordforms.getEndingsRegex(nounGuesses);
        NOUN_PATTERN = Pattern.compile(NOUN_ENDINGS_REGEX);
        BASEFORMS = new String[]{"sg.nom", "sg.gen", "pl.nom", "pl.gen"};
    }
}

