/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Scanner;
import org.languagetool.DetectedLanguage;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;

public class FilterFileByLanguage {
    private static final String fastTextBinary = "/home/languagetool/fasttext/fasttext";
    private static final String fastTextModel = "/home/languagetool/fasttext/lid.176.bin";
    private static final String nGramData = "/home/languagetool/model_ml50_new.zip";
    private static final float skipThreshold = 0.95f;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + FilterFileByLanguage.class.getSimpleName() + " <langCode> <file>");
            System.exit(1);
        }
        String expectedLang = args[0];
        File input = new File(args[1]);
        File output = new File(input.getAbsoluteFile() + ".filtered");
        LanguageIdentifier ident = LanguageIdentifierService.INSTANCE.getDefaultLanguageIdentifier(0, new File(nGramData), new File(fastTextBinary), new File(fastTextModel));
        Scanner sc = new Scanner(input);
        int skipCount = 0;
        try (FileWriter fw = new FileWriter(output);){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                DetectedLanguage lang = ident.detectLanguage(line, Collections.emptyList(), Collections.emptyList());
                if (lang != null && !lang.getDetectedLanguage().getShortCode().equals(expectedLang) && lang.getDetectionConfidence() > 0.95f) {
                    System.out.printf("Skipping (%.2f, %s): %s\n", Float.valueOf(lang.getDetectionConfidence()), lang.getDetectedLanguage().getShortCode(), line);
                    ++skipCount;
                    continue;
                }
                fw.write(line);
                fw.write("\n");
            }
        }
        System.out.println(skipCount + " lines skipped, confidence threshold was 0.95");
        System.out.println("Filtered result written to " + output);
    }
}

