/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.CategoryId;

public final class Category {
    private final String name;
    private final CategoryId id;
    private final Location location;
    private final boolean defaultOff;

    public Category(CategoryId id, String name) {
        this(id, name, Location.INTERNAL, true);
    }

    public Category(String name) {
        this(name, Location.INTERNAL);
    }

    public Category(String name, Location location) {
        this(name, location, true);
    }

    public Category(String name, Location location, boolean onByDefault) {
        this(null, name, location, onByDefault);
    }

    public Category(CategoryId id, String name, Location location) {
        this(id, name, location, true);
    }

    public Category(CategoryId id, String name, Location location, boolean onByDefault) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.defaultOff = !onByDefault;
    }

    @Nullable
    public CategoryId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isDefaultOff() {
        return this.defaultOff;
    }

    public Location getLocation() {
        return this.location;
    }

    public static enum Location {
        INTERNAL,
        EXTERNAL;

    }
}

