/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.util.List;
import net.sourceforge.segment.srx.SrxDocument;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SrxTools;

public class SRXSentenceTokenizer
implements SentenceTokenizer {
    private static final SrxDocument DOCUMENT = SrxTools.createSrxDocument(JLanguageTool.getDataBroker().getFromResourceDirAsStream("/segment.srx"));
    private final String languageCode;
    private String parCode;

    public SRXSentenceTokenizer(Language language) {
        this.languageCode = language.getShortName();
        this.setSingleLineBreaksMarksParagraph(false);
    }

    @Override
    public final List<String> tokenize(String text) {
        return SrxTools.tokenize(text, DOCUMENT, this.languageCode + this.parCode);
    }

    @Override
    public final boolean singleLineBreaksMarksPara() {
        return "_one".equals(this.parCode);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }
}

