/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import net.sourceforge.segment.srx.SrxDocument;
import org.languagetool.Language;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SrxTools;
import org.languagetool.tools.Tools;

public class LocalSRXSentenceTokenizer
implements SentenceTokenizer {
    private final SrxDocument srxDocument;
    private final Language language;
    private String parCode;

    public LocalSRXSentenceTokenizer(Language language, String srxInClassPath) {
        this.language = Objects.requireNonNull(language);
        try {
            InputStream stream = Tools.getStream(srxInClassPath);
            this.srxDocument = SrxTools.createSrxDocument(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSingleLineBreaksMarksParagraph(false);
    }

    @Override
    public final List<String> tokenize(String text) {
        return SrxTools.tokenize(text, this.srxDocument, this.language.getShortName() + this.parCode);
    }

    @Override
    public final boolean singleLineBreaksMarksPara() {
        return "_one".equals(this.parCode);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }
}

