/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import morfologik.fsa.CFSA2Serializer;
import morfologik.fsa.FSA;
import morfologik.fsa.FSABuilder;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

public class MorfologikMultiSpeller {
    private final List<MorfologikSpeller> spellers = new ArrayList<MorfologikSpeller>();
    private final boolean convertsCase;

    public MorfologikMultiSpeller(String binaryDictPath, String plainTextPath, int maxEditDistance) throws IOException {
        MorfologikSpeller speller = this.getBinaryDict(binaryDictPath, maxEditDistance);
        this.spellers.add(speller);
        this.convertsCase = speller.convertsCase();
        String infoFile = binaryDictPath.replace(".dict", ".info");
        MorfologikSpeller plainTextDict = this.getPlainTextDictOrNull(plainTextPath, infoFile, maxEditDistance);
        if (plainTextDict != null) {
            this.spellers.add(plainTextDict);
        }
    }

    private MorfologikSpeller getBinaryDict(String binaryDictPath, int maxEditDistance) throws IOException {
        if (binaryDictPath.endsWith(".dict")) {
            return new MorfologikSpeller(binaryDictPath, maxEditDistance);
        }
        throw new RuntimeException("Unsupported dictionary, binary Morfologik file needs to have suffix .dict: " + binaryDictPath);
    }

    @Nullable
    private MorfologikSpeller getPlainTextDictOrNull(String plainTextPath, String infoFile, int maxEditDistance) throws IOException {
        if (plainTextPath.endsWith(".txt")) {
            InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(plainTextPath);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, "utf-8"));){
                List<byte[]> lines = this.getLines(br);
                if (lines.size() == 0) {
                    MorfologikSpeller morfologikSpeller = null;
                    return morfologikSpeller;
                }
                Dictionary dictionary = this.getDictionary(lines, infoFile);
                MorfologikSpeller morfologikSpeller = new MorfologikSpeller(dictionary, maxEditDistance);
                return morfologikSpeller;
            }
        }
        throw new RuntimeException("Unsupported dictionary, plain text file needs to have suffix .txt: " + plainTextPath);
    }

    private List<byte[]> getLines(BufferedReader br) throws IOException {
        String line;
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(line.getBytes("utf-8"));
        }
        return lines;
    }

    private Dictionary getDictionary(List<byte[]> lines, String infoFile) throws IOException {
        Collections.sort(lines, FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(lines);
        ByteArrayOutputStream fsaOutStream = (ByteArrayOutputStream)new CFSA2Serializer().serialize(fsa, (OutputStream)new ByteArrayOutputStream());
        ByteArrayInputStream fsaInStream = new ByteArrayInputStream(fsaOutStream.toByteArray());
        return Dictionary.readAndClose((InputStream)fsaInStream, (InputStream)JLanguageTool.getDataBroker().getFromResourceDirAsStream(infoFile));
    }

    public boolean isMisspelled(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            if (speller.isMisspelled(word)) continue;
            return false;
        }
        return true;
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> result = new ArrayList<String>();
        for (MorfologikSpeller speller : this.spellers) {
            List<String> suggestions = speller.getSuggestions(word);
            for (String suggestion : suggestions) {
                if (result.contains(suggestion)) continue;
                result.add(suggestion);
            }
        }
        return result;
    }

    public boolean convertsCase() {
        return this.convertsCase;
    }
}

