/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractPatternRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private final Set<String> simpleRuleTokens;
    private final Set<String> inflectedRuleTokens;
    private final List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    private final boolean useList;
    private RuleFilter filter;
    private String filterArgs;
    private String message;
    private String suggestionsOutMsg;
    private List<Match> suggestionMatches;
    private List<Match> suggestionMatchesOutMsg;
    private Set<String> tokenSet;
    private Set<String> lemmaSet;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage) {
        super(id, description, language, patternTokens, false);
        this.message = message;
        this.shortMessage = shortMessage;
        this.elementNo = new ArrayList<Integer>();
        this.suggestionsOutMsg = "";
        String prevName = "";
        int cnt = 0;
        int loopCnt = 0;
        boolean tempUseList = false;
        for (PatternToken pToken : this.patternTokens) {
            if (pToken.isPartOfPhrase()) {
                String curName = pToken.getPhraseName();
                if (StringTools.isEmpty(prevName) || prevName.equals(curName)) {
                    ++cnt;
                    tempUseList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternTokens.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
        this.useList = tempUseList;
        this.simpleRuleTokens = this.getSimpleTokens();
        this.inflectedRuleTokens = this.getInflectedTokens();
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg) {
        this(id, language, patternTokens, description, message, shortMessage);
        this.suggestionsOutMsg = suggestionsOutMsg;
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (PatternToken patternPatternToken : this.patternTokens) {
            strList.add(patternPatternToken.toString());
        }
        return StringTools.listToString(strList, ", ");
    }

    public final String toXML() {
        return new PatternRuleXmlCreator().toXML(new PatternRuleId(this.getId(), this.getSubId()), this.getLanguage());
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        try {
            PatternRuleMatcher matcher = new PatternRuleMatcher(this, this.useList);
            return matcher.match(this.getSentenceWithImmunization(sentence));
        }
        catch (IOException e) {
            throw new IOException("Error analyzing sentence: '" + sentence + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error analyzing sentence: '" + sentence + "'", e);
        }
    }

    public final void addSuggestionMatch(Match m) {
        if (this.suggestionMatches == null) {
            this.suggestionMatches = new ArrayList<Match>();
        }
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        if (this.suggestionMatchesOutMsg == null) {
            this.suggestionMatchesOutMsg = new ArrayList<Match>();
        }
        this.suggestionMatchesOutMsg.add(m);
    }

    final List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns;
    }

    public boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        return !this.simpleRuleTokens.isEmpty() && !sentence.getTokenSet().containsAll(this.simpleRuleTokens) || !this.inflectedRuleTokens.isEmpty() && !sentence.getLemmaSet().containsAll(this.inflectedRuleTokens);
    }

    private synchronized Set<String> getSimpleTokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new HashSet<String>();
            for (PatternToken patternToken : this.patternTokens) {
                String str;
                if (patternToken.getNegation() || patternToken.isRegularExpression() || patternToken.isReferenceElement() || patternToken.isInflected() || patternToken.getMinOccurrence() <= 0 || StringTools.isEmpty(str = patternToken.getString())) continue;
                this.tokenSet.add(str.toLowerCase());
            }
        }
        return this.tokenSet;
    }

    private synchronized Set<String> getInflectedTokens() {
        if (this.lemmaSet == null) {
            this.lemmaSet = new HashSet<String>();
            for (PatternToken patternToken : this.patternTokens) {
                String str;
                if (patternToken.getNegation() || patternToken.isRegularExpression() || patternToken.isReferenceElement() || !patternToken.isInflected() || patternToken.getMinOccurrence() <= 0 || StringTools.isEmpty(str = patternToken.getString())) continue;
                this.lemmaSet.add(str.toLowerCase());
            }
        }
        return this.lemmaSet;
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    String getShortMessage() {
        return this.shortMessage;
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg;
    }

    void setFilter(RuleFilter filter) {
        this.filter = filter;
    }

    RuleFilter getFilter() {
        return this.filter;
    }

    void setFilterArguments(String filterArgs) {
        this.filterArgs = filterArgs;
    }

    String getFilterArguments() {
        return this.filterArgs;
    }

    public void setAntiPatterns(List<DisambiguationPatternRule> antiPatterns) {
        this.antiPatterns.addAll(antiPatterns);
    }

    private AnalyzedSentence getSentenceWithImmunization(AnalyzedSentence sentence) throws IOException {
        if (this.antiPatterns != null && !this.antiPatterns.isEmpty()) {
            AnalyzedSentence immunizedSentence = sentence.copy(sentence);
            for (DisambiguationPatternRule patternRule : this.antiPatterns) {
                immunizedSentence = patternRule.replace(immunizedSentence);
            }
            return immunizedSentence;
        }
        return sentence;
    }
}

