/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.RuleMatch;

public abstract class Rule {
    protected final ResourceBundle messages;
    private List<String> correctExamples = new ArrayList<String>();
    private List<IncorrectExample> incorrectExamples = new ArrayList<IncorrectExample>();
    private ITSIssueType locQualityIssueType = ITSIssueType.Uncategorized;
    private Category category;
    private URL url;
    private boolean defaultOff;

    public Rule() {
        this(null);
    }

    public Rule(ResourceBundle messages) {
        this.messages = messages;
    }

    public abstract String getId();

    public abstract String getDescription();

    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    public abstract void reset();

    public boolean supportsLanguage(Language language) {
        try {
            ArrayList relevantRuleClasses = new ArrayList();
            List<Rule> relevantRules = language.getRelevantRules(JLanguageTool.getMessageBundle());
            for (Rule relevantRule : relevantRules) {
                relevantRuleClasses.add(relevantRule.getClass());
            }
            return relevantRuleClasses.contains(this.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDictionaryBasedSpellingRule() {
        return false;
    }

    public boolean useInOffice() {
        return false;
    }

    public final void setCorrectExamples(List<String> correctExamples) {
        this.correctExamples = Objects.requireNonNull(correctExamples);
    }

    public final List<String> getCorrectExamples() {
        return this.correctExamples;
    }

    public final void setIncorrectExamples(List<IncorrectExample> incorrectExamples) {
        this.incorrectExamples = Objects.requireNonNull(incorrectExamples);
    }

    public final List<IncorrectExample> getIncorrectExamples() {
        return this.incorrectExamples;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final void setCategory(Category category) {
        this.category = category;
    }

    protected final RuleMatch[] toRuleMatchArray(List<RuleMatch> ruleMatches) {
        return ruleMatches.toArray(new RuleMatch[ruleMatches.size()]);
    }

    public final boolean isDefaultOff() {
        return this.defaultOff;
    }

    public final void setDefaultOff() {
        this.defaultOff = true;
    }

    public final void setDefaultOn() {
        this.defaultOff = false;
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public ITSIssueType getLocQualityIssueType() {
        return this.locQualityIssueType;
    }

    public void setLocQualityIssueType(ITSIssueType locQualityIssueType) {
        this.locQualityIssueType = Objects.requireNonNull(locQualityIssueType);
    }

    protected void addExamplePair(IncorrectExample incorrectSentence, String correctSentence) {
        this.incorrectExamples.add(incorrectSentence);
        this.correctExamples.add(correctSentence);
    }
}

