/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class ConfusionProbabilityRule
extends Rule {
    private static final int MIN_SCORE_DIFF = 6;
    private static final int MIN_ALTERNATIVE_SCORE = 14;
    private static final int MAX_TEXT_SCORE = Integer.MAX_VALUE;
    private static final int MIN_SENTENCES = 0;
    private static final float MAX_ERROR_RATE = 10.0f;
    private static final String HOMOPHONES = "homophones.txt";
    private static final String HOMOPHONES_INFO = "homophones-info.txt";
    private final Map<String, ConfusionSet> wordToSet;
    private final LanguageModel languageModel;

    @Override
    public abstract String getDescription();

    public abstract String getMessage(String var1);

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) throws IOException {
        super(messages);
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String prefix = "/" + language.getShortName() + "/";
        InputStream homophonesInfoStream = dataBroker.getFromResourceDirAsStream(prefix + HOMOPHONES_INFO);
        ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader(homophonesInfoStream, 0, 10.0f);
        InputStream homophonesStream = dataBroker.getFromResourceDirAsStream(prefix + HOMOPHONES);
        this.wordToSet = confusionSetLoader.loadConfusionSet(homophonesStream);
        this.languageModel = languageModel;
    }

    @Override
    public String getId() {
        return "CONFUSION_RULE";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedTokenReadings token : tokens) {
            String betterAlternative;
            boolean isEasilyConfused;
            ConfusionSet confusionSet = this.wordToSet.get(token.getToken());
            boolean bl = isEasilyConfused = confusionSet != null;
            if (isEasilyConfused && (betterAlternative = this.getBetterAlternativeOrNull(tokens, pos, confusionSet)) != null) {
                int endPos = token.getStartPos() + token.getToken().length();
                RuleMatch match = new RuleMatch(this, token.getStartPos(), endPos, this.getMessage(betterAlternative));
                match.setSuggestedReplacement(betterAlternative);
                matches.add(match);
            }
            ++pos;
        }
        return matches.toArray(new RuleMatch[matches.size()]);
    }

    @Override
    public void reset() {
    }

    public void setConfusionSet(ConfusionSet set) {
        this.wordToSet.clear();
        for (String word : set.set) {
            this.wordToSet.put(word, set);
        }
    }

    @Nullable
    String getBetterAlternativeOrNull(AnalyzedTokenReadings[] tokens, int pos, ConfusionSet confusionSet) {
        AnalyzedTokenReadings token = tokens[pos];
        String next = this.getStringAtOrNull(tokens, pos + 1);
        String next2 = this.getStringAtOrNull(tokens, pos + 2);
        String prev = this.getStringAtOrNull(tokens, pos - 1);
        String prev2 = this.getStringAtOrNull(tokens, pos - 2);
        if ((next + next2 + prev + prev2).contains(",")) {
            return null;
        }
        double textScore = this.score(token.getToken(), next, next2, prev, prev2);
        if (textScore >= 2.147483647E9) {
            return null;
        }
        double bestScore = textScore;
        String betterAlternative = null;
        for (String alternative : confusionSet.set) {
            double alternativeScore;
            if (alternative.equalsIgnoreCase(token.getToken()) || !((alternativeScore = this.score(alternative, next, next2, prev, prev2)) >= bestScore + 6.0) || !(alternativeScore >= 14.0)) continue;
            betterAlternative = alternative;
            bestScore = alternativeScore;
        }
        return betterAlternative;
    }

    @Nullable
    private String getStringAtOrNull(AnalyzedTokenReadings[] tokens, int i) {
        if (i == -1) {
            return null;
        }
        if (i >= tokens.length) {
            return null;
        }
        if (i >= 0 && i < tokens.length) {
            return tokens[i].getToken();
        }
        return null;
    }

    private double score(String option, String next1, String next2, String prev1, String prev2) {
        Objects.requireNonNull(option);
        long ngram3 = prev1 != null && next1 != null ? this.languageModel.getCount(prev1, option, next1) : 0L;
        long ngram3left = prev2 != null && prev1 != null ? this.languageModel.getCount(prev2, prev1, option) : 0L;
        long ngram3right = next1 != null && next2 != null ? this.languageModel.getCount(option, next1, next2) : 0L;
        double val3 = Math.log(Math.max(1L, ngram3));
        double val4 = Math.log(Math.max(1L, ngram3left));
        double val5 = Math.log(Math.max(1L, ngram3right));
        double val = val3 + val4 + val5;
        return val;
    }

    public static class ConfusionSet {
        private final Set<String> set = new HashSet<String>();

        ConfusionSet(String ... words) {
            Collections.addAll(this.set, words);
        }

        public Set<String> getSet() {
            return this.set;
        }

        public String toString() {
            return this.set.toString();
        }
    }
}

