/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AbstractSimpleReplaceRule
extends Rule {
    private static final String FILE_ENCODING = "utf-8";
    private final Map<String, List<String>> wrongWords;
    private boolean ignoreTaggedWords = false;
    private boolean checkLemmas = true;

    public abstract String getFileName();

    public String getEncoding() {
        return FILE_ENCODING;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    public AbstractSimpleReplaceRule(ResourceBundle messages) throws IOException {
        super.setCategory(new Category(messages.getString("category_misc")));
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    @Override
    public String getId() {
        return "SIMPLE_REPLACE";
    }

    @Override
    public String getDescription() {
        return "Checks for wrong words/phrases";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " is not valid. Use: " + StringUtils.join(replacements, (String)", ") + ".";
    }

    public String getShort() {
        return "Wrong word";
    }

    private String cleanup(String word) {
        return this.isCaseSensitive() ? word : word.toLowerCase(this.getLocale());
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            List<String> possibleReplacements;
            if (tokenReadings.isImmunized() || tokenReadings.isIgnoredBySpeller()) continue;
            String originalTokenStr = tokenReadings.getToken();
            if (this.ignoreTaggedWords && this.isTagged(tokenReadings)) continue;
            String tokenString = this.cleanup(originalTokenStr);
            if (!this.wrongWords.containsKey(tokenString) && this.checkLemmas) {
                for (AnalyzedToken analyzedToken : tokenReadings.getReadings()) {
                    String lemma = analyzedToken.getLemma();
                    if (lemma == null || !this.wrongWords.containsKey(lemma = this.cleanup(lemma))) continue;
                    tokenString = lemma;
                    break;
                }
            }
            if ((possibleReplacements = this.wrongWords.get(originalTokenStr)) == null) {
                possibleReplacements = this.wrongWords.get(tokenString);
            }
            if (possibleReplacements == null || possibleReplacements.size() <= 0) continue;
            ArrayList<String> replacements = new ArrayList<String>();
            replacements.addAll(possibleReplacements);
            if (replacements.contains(originalTokenStr)) {
                replacements.remove(originalTokenStr);
            }
            if (replacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected boolean isTagged(AnalyzedTokenReadings tokenReadings) {
        return tokenReadings.isTagged();
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, List<String> replacements) {
        String tokenString = tokenReadings.getToken();
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch(this, pos, pos + tokenString.length(), this.getMessage(tokenString, replacements), this.getShort());
        if (!this.isCaseSensitive() && StringTools.startsWithUppercase(tokenString)) {
            for (int i = 0; i < replacements.size(); ++i) {
                replacements.set(i, StringTools.uppercaseFirstChar(replacements.get(i)));
            }
        }
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    private Map<String, List<String>> loadWords(InputStream stream) throws IOException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try (Scanner scanner = new Scanner(stream, this.getEncoding());){
            while (scanner.hasNextLine()) {
                String[] wrongForms;
                String line = scanner.nextLine();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    URL filename = JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName());
                    throw new IOException("Format error in file " + filename + ", line: " + line);
                }
                String[] replacements = parts[1].split("\\|");
                for (String wrongForm : wrongForms = parts[0].split("\\|")) {
                    map.put(wrongForm, Arrays.asList(replacements));
                }
            }
        }
        return map;
    }

    public boolean isCheckLemmas() {
        return this.checkLemmas;
    }

    public void setCheckLemmas(boolean checkLemmas) {
        this.checkLemmas = checkLemmas;
    }

    @Override
    public void reset() {
    }
}

